<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;
use Illuminate\Support\Str;

class SettingSeeder extends Seeder
{
  /**
   * Run the database seeds.
   *
   * @return void
   */
  public function run()
  {
    Setting::create([
      'key' => 'APPLICATION_NAME',
      'value' => 'JupiterMeet Pro'
    ]);

    Setting::create([
      'key' => 'PRIMARY_COLOR',
      'value' => '#7453f0'
    ]);

    Setting::create([
      'key' => 'PRIMARY_LOGO',
      'value' => 'PRIMARY_LOGO.png'
    ]);

    Setting::create([
      'key' => 'FAVICON',
      'value' => 'FAVICON.png'
    ]);

    Setting::create([
      'key' => 'SIGNALING_URL',
      'value' => 'https://yourdomain.in:9007'
    ]);

    Setting::create([
      'key' => 'DEFAULT_USERNAME',
      'value' => 'Guest'
    ]);

    Setting::create([
      'key' => 'COOKIE_CONSENT',
      'value' => 'enabled'
    ]);

    Setting::create([
      'key' => 'LANDING_PAGE',
      'value' => 'enabled'
    ]);

    Setting::create([
      'key' => 'GOOGLE_ANALYTICS_ID',
      'value' => null
    ]);
    
    Setting::create([
      'key' => 'CAPTCHA_LOGIN_PAGE',
      'value' => 'disabled'
    ]);

    Setting::create([
      'key' => 'SOCIAL_INVITATION',
      'value' => 'Hey, check out this amazing website, where you can host video meetings!'
    ]);

    Setting::create([
      'key' => 'MODERATOR_RIGHTS',
      'value' => 'enabled'
    ]);

    Setting::create([
      'key' => 'AUTH_MODE',
      'value' => 'enabled'
    ]);

    Setting::create([
      'key' => 'PAYMENT_MODE',
      'value' => 'disabled'
    ]);

    Setting::create([
      'key' => 'REGISTRATION',
      'value' => 'enabled'
    ]);
    
    Setting::create([
      'key' => 'VERIFY_USERS',
      'value' => 'disabled'
    ]);

    Setting::create([
      'key' => 'STRIPE_KEY',
      'value' => 'pk_test_example'
    ]);

    Setting::create([
      'key' => 'STRIPE_SECRET',
      'value' => 'sk_test_example'
    ]);

    Setting::create([
      'key' => 'STRIPE',
      'value' => '0'
    ]);

    Setting::create([
      'key' => 'STRIPE_WH_SECRET',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'PAYPAL',
      'value' => '0'
    ]);

    Setting::create([
      'key' => 'PAYPAL_MODE',
      'value' => 'sandbox'
    ]);

    Setting::create([
      'key' => 'PAYPAL_CLIENT_ID',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'PAYPAL_SECRET',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'PAYPAL_WEBHOOK_ID',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'END_URL',
      'value' => '/pages/thank-you'
    ]);
    
    Setting::create([
      'key' => 'CUSTOM_JS',
      'value' => ''
    ]);
    
    Setting::create([
      'key' => 'CUSTOM_CSS',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'MAIL_MAILER',
      'value' => 'smtp'
    ]);
    
    Setting::create([
      'key' => 'MAIL_HOST',
      'value' => 'localhost'
    ]);
    
    Setting::create([
      'key' => 'MAIL_PORT',
      'value' => '1025'
    ]);
    
    Setting::create([
      'key' => 'MAIL_USERNAME',
      'value' => ''
    ]);
    
    Setting::create([
      'key' => 'MAIL_PASSWORD',
      'value' => ''
    ]);
    
    Setting::create([
      'key' => 'MAIL_ENCRYPTION',
      'value' => ''
    ]);
    
    Setting::create([
      'key' => 'MAIL_FROM_ADDRESS',
      'value' => 'admin@example.com'
    ]);
    
    Setting::create([
      'key' => 'API_TOKEN',
      'value' => Str::random(60)
    ]);

    Setting::create([
      'key' => 'VERSION',
      'value' => '2.0.1'
    ]);

    Setting::create([
      'key' => 'PAYSTACK',
      'value' => '0'
    ]);

    Setting::create([
      'key' => 'PAYSTACK_SECRET_KEY',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'MOLLIE',
      'value' => '0'
    ]);

    Setting::create([
      'key' => 'MOLLIE_API_KEY',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'RAZORPAY',
      'value' => '0'
    ]);

    Setting::create([
      'key' => 'RAZORPAY_API_KEY',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'RAZORPAY_SECRET_KEY',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'PWA',
      'value' => 'disabled'
    ]);

    Setting::create([
      'key' => 'LIMITED_SCREEN_SHARE',
      'value' => '0'
    ]);

    Setting::create([
      'key' => 'GOOGLE_RECAPTCHA_KEY',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'GOOGLE_RECAPTCHA_SECRET',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'CAPTCHA_REGISTER_PAGE',
      'value' => '0'
    ]);

    Setting::create([
      'key' => 'GOOGLE_RECAPTCHA',
      'value' => '0'
    ]);

    Setting::create([
      'key' => 'COMPANY_NAME',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'COMPANY_ADDRESS',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'COMPANY_CITY',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'COMPANY_STATE',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'COMPANY_POSTAL_CODE',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'COMPANY_COUNTRY',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'COMPANY_PHONE',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'COMPANY_EMAIL',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'COMPANY_TAX_ID',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'GOOGLE_SOCIAL_LOGIN',
      'value' => 'disabled'
    ]);

    Setting::create([
      'key' => 'GOOGLE_CLIENT_ID',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'GOOGLE_CLIENT_SECRET',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'FACEBOOK_SOCIAL_LOGIN',
      'value' => 'disabled'
    ]);

    Setting::create([
      'key' => 'FACEBOOK_CLIENT_ID',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'FACEBOOK_CLIENT_SECRET',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'LINKEDIN_SOCIAL_LOGIN',
      'value' => 'disabled'
    ]);

    Setting::create([
      'key' => 'LINKEDIN_CLIENT_ID',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'LINKEDIN_CLIENT_SECRET',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'TWITTER_SOCIAL_LOGIN',
      'value' => 'disabled'
    ]);

    Setting::create([
      'key' => 'TWITTER_CLIENT_ID',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'TWITTER_CLIENT_SECRET',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'KEY_PATH',
      'value' => '/etc/letsencrypt/live/yourdomain.com/privkey.pem'
    ]);

    Setting::create([
      'key' => 'CERT_PATH',
      'value' => '/etc/letsencrypt/live/yourdomain.com/fullchain.pem'
    ]);

    Setting::create([
      'key' => 'PORT',
      'value' => '9007'
    ]);

    Setting::create([
      'key' => 'MAX_FILESIZE',
      'value' => '50'
    ]);

    Setting::create([
      'key' => 'IP',
      'value' => '0.0.0.0'
    ]);

    Setting::create([
      'key' => 'ANNOUNCED_IP',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'RTC_MIN_PORT',
      'value' => '10000'
    ]);

    Setting::create([
      'key' => 'RTC_MAX_PORT',
      'value' => '59999'
    ]);

    Setting::create([
      'key' => 'AI_CHATBOT_API_KEY',
      'value' => ''
    ]);

    Setting::create([
      'key' => 'AI_CHATBOT_API_URL',
      'value' => 'https://api.openai.com/v1'
    ]);

    Setting::create([
      'key' => 'AI_CHATBOT_MODEL',
      'value' => 'gpt-3.5-turbo'
    ]);

    Setting::create([
      'key' => 'AI_CHATBOT_SECONDS',
      'value' => '10'
    ]);

    Setting::create([
      'key' => 'AI_CHATBOT_MESSAGE_LIMIT',
      'value' => '50'
    ]);

    Setting::create([
      'key' => 'AI_CHATBOT_MAX_CONVERSATION_LENGTH',
      'value' => '10'
    ]);
    
    Setting::create([
      'key' => 'DEFAULT_THEME',
      'value' => 'light'
    ]);

  }
}