@extends('layouts.admin')
@section('title', $pageTitle)

@section('content')
    @include('include.admin.toast')

    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-xl">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        @include('include.admin.breadcrumbs')
                    </div>
                    <div class="col-auto ms-auto me-3">
                        <div class="btn-list">
                            <span class="d-sm-inline">
                                <a href="{{ route('export-user', request()->all()) }}" class="btn hideLoader">
                                    {{ __('Export') }}
                                </a>
                            </span>
                            <span class="d-sm-inline">
                                <a href="{{ route('admin.user.create') }}" class="btn btn-primary btn-5">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon me-0" width="24" height="24"
                                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                        stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M12 5l0 14" />
                                        <path d="M5 12l14 0" />
                                    </svg>
                                    <span class="d-none d-sm-inline-block">{{ __('Create New') }}
                                </a>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-xl">
                <div class="accordion mb-3" id="userSearch">
                    <div class="accordion-item">
                        <h4 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#userSearchForm" aria-expanded="true">
                                {{ __('Search') }}
                            </button>
                        </h4>
                        <div id="userSearchForm"
                            class="accordion-collapse collapse @if ($isFiltered) show @endif"
                            data-bs-parent="#userSearch">
                            <div class="accordion-body pt-0">
                                @include('admin.user.search')
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="table-responsive">
                        <table class="table card-table table-vcenter text-nowrap datatable">
                            <thead>
                                <tr>
                                    <th>{{ __('SR No') }}</th>
                                    <th>{{ __('Avatar') }}</th>
                                    <th>{{ __('First Name') }}</th>
                                    <th>{{ __('Last Name') }}</th>
                                    <th>{{ __('Username') }}</th>
                                    <th>{{ __('Email') }}</th>
                                    <th>{{ __('Plan') }}</th>
                                    <th>{{ __('Source') }}</th>
                                    <th>{{ __('Created Date') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($users as $user)
                                    <tr>
                                        <td>{{ $users->firstItem() + $loop->index }}</td>
                                        <td>
                                            @if ($user->avatar)
                                                <span class="avatar"
                                                    style="background-image: url('{{ asset('storage/avatars/' . $user->avatar) }}')">
                                                </span>
                                            @else
                                                <span class="avatar"
                                                    style="background-image: url('{{ asset('/images/blank.jpeg') }}')"></span>
                                            @endif
                                        </td>
                                        <td class="text-truncate" title="{{ $user->first_name }}">
                                            {{ $user->first_name ?? '-' }}</td>
                                        <td class="text-truncate" title="{{ $user->last_name }}">
                                            {{ $user->last_name ?? '-' }}</td>
                                        <td class="text-truncate" title="{{ $user->username }}">{{ $user->username }}</td>
                                        <td class="text-truncate" title="{{ $user->email }}">{{ $user->email }}</td>
                                        <td>
                                            <select class="form-control dropdown-toggle assignPlanDropdown">
                                                @foreach ($plans as $plan)
                                                    <option value="{{ $plan->id }}|{{ $user->id }}"
                                                        {{ $plan->id == $user->plan_id ? 'selected' : '' }}>
                                                        {{ $plan->name }}</option>
                                                @endforeach
                                            </select>
                                        </td>
                                        @if ($user->facebook_id)
                                            <td>Facebook</td>
                                        @elseif ($user->twitter_id)
                                            <td>Twitter</td>
                                        @elseif ($user->google_id)
                                            <td>Google</td>
                                        @elseif ($user->linkedin_id)
                                            <td>LinkedIn</td>
                                        @else
                                            <td>{{ __('Register') }}</td>
                                        @endif

                                        <td>{{ $user->created_at->diffForHumans() }}</td>
                                        <td>
                                            <div class="form-switch">
                                                <input class="form-check-input toggle-user-status" type="checkbox"
                                                    data-id="{{ $user->id }}"
                                                    value="{{ $user->status === 'active' ? 'active' : 'inactive' }}"
                                                    {{ $user->status === 'active' ? 'checked' : '' }}>
                                            </div>
                                        </td>
                                        <td>
                                            <a class="btn" href = "{{ route('admin.user.destroy', $user->id) }}"
                                                onclick="return confirm('Are you sure you want to delete this User?')"
                                                title="{{ __('Delete') }}">
                                                {{ __('Delete') }}
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td>{{ __('No Records Found') }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    @if ($users->hasPages())
                        <div class="mt-2 ms-2">
                            {{ $users->links('pagination::bootstrap-5') }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script src="{{ asset('/js/litepicker.js') }}"></script>
    <script>
        const picker = new Litepicker({
            element: document.getElementById('litepicker'),
            singleMode: false,
            format: 'YYYY/MM/DD',
            autoApply: true,
        });

        $(document).ready(function() {
            $("#clearDate").click(function() {
                $("#litepicker").val("");
            });
        });
    </script>
@endsection
