@extends('layouts.auth')

@section('title', __('Login'))

@section('content')
    <div class="page page-center">
        <div class="container container-tight py-4">
            <div class="text-center mb-4">
                <a href="{{ route('home') }}" class="navbar-brand navbar-brand-autodark">
                    <img src="{{ asset('storage/images/' . getSetting('PRIMARY_LOGO')) }}" width="200"
                        alt="{{ __('Logo') }}" class="navbar-brand-image">
                </a>
            </div>
            <div class="card card-md">
                <div class="card-body">
                    <h2 class="h2 text-center mb-4">{{ __('Login to your account') }}</h2>
                    <form id="loginForm" method="POST" action="{{ route('login') }}">
                        @csrf

                        <div class="mb-3">
                            <label class="form-label">{{ __('Email address or username') }}</label>
                            <input id="email" type="text" class="form-control @error('email') is-invalid @enderror"
                                name="email" value="{{ old('email') }}" maxlength="50"
                                placeholder="{{ __('Your email or username') }}" autocomplete="email" required autofocus>

                            @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="mb-2">
                            <label class="form-label">
                                {{ __('Password') }}
                            </label>
                            <div class="input-group input-group-flat">
                                <input id="password" type="password"
                                    class="form-control @error('password') is-invalid @enderror"
                                    placeholder="{{ __('Password') }}" name="password" maxlength="50" required
                                    autocomplete="current-password">

                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror

                                <span class="input-group-text">
                                    <a class="link-secondary jm-toggle-password" data-bs-toggle="tooltip">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                            viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                                            <path
                                                d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" />
                                        </svg>
                                    </a>
                                </span>
                            </div>

                            <span class="form-label-description mt-2">
                                <a href="{{ route('password.request') }}">{{ __('Forgot your password?') }}</a>
                            </span>
                        </div>
                        <div class="mb-2">
                            <label class="form-check">
                                <input class="form-check-input" type="checkbox" name="remember" id="remember"
                                    {{ old('remember') ? 'checked' : '' }}>

                                <span class="form-check-label">{{ __('Remember me') }}</span>
                            </label>
                        </div>

                        @if (getSetting('CAPTCHA_LOGIN_PAGE') == 'enabled')
                            <div class="form-group mt-5">
                                <div class="col-12">
                                    <div class="g-recaptcha" id="recaptcha-div"
                                        data-sitekey="{{ getSetting('GOOGLE_RECAPTCHA_KEY') }}">
                                    </div>
                                    @if ($errors->has('g-recaptcha-response'))
                                        <span class="invalid-feedback" role="alert" style="display: block">
                                            <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        @endif

                        <div class="form-footer">
                            <button type="submit" id="loginButton"
                                class="btn btn-primary w-100">{{ __('Login') }}</button>
                        </div>
                    </form>

                    @if (isDemoMode())
                        <div class="mt-3">
                            <select id="autoLogin" class="form-select">
                                <option value="">Auto login as (demo only)</option>
                                <option value="admin">Admin</option>
                                <option value="user_1">User 1</option>
                                <option value="user_2">User 2</option>
                            </select>
                        </div>
                    @endif
                </div>

                @include('auth.social-logins')
            </div>
            @if (getSetting('REGISTRATION') == 'enabled' && getSetting('AUTH_MODE') == 'enabled')
                <div class="text-center text-secondary mt-3">
                    {{ __("Don't have account yet?") }}
                    <a href="{{ route('register') }}" tabindex="-1">
                        {{ __('Register') }}
                    </a>
                </div>
            @endif
        </div>
    </div>
@endsection

@section('script')
    <script src="https://www.google.com/recaptcha/api.js"></script>
@endsection
