<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ getSelectedLanguage()->direction }}"
    data-bs-theme-base="neutral" data-bs-theme="{{ getThemeFromSession() }}">

<head>
    @include('include.layouts.common.head')
    <meta name="description" content="@yield('description')" />

    <link href="{{ asset('/css/home.css') }}" rel="stylesheet" />
    <style>
        {!! getSetting('CUSTOM_CSS') !!}
    </style>
    {!! getSetting('CUSTOM_JS') !!}
    @stack('styles')
</head>

<body>
    @include('include.user.toast')
    @yield('home-content')

    @include('include.layouts.common.body')

    <script>
        const cookieConsent = "{{ getSetting('COOKIE_CONSENT') }}";
        const socialInvitation = `{{ getSetting('SOCIAL_INVITATION') }}`;
        const googleAnalyticsTrackingId = "{{ getSetting('GOOGLE_ANALYTICS_ID') }}";

        const languages = {
            no_meeting: "{{ __('The meeting does not exist') }}",
        }
    </script>

    <script src="{{ asset('/js/main.js?version=') . getVersion() }}"></script>
    @stack('scripts')
</body>

</html>
