<?php

use App\Http\Controllers\API\v1\AuthController;
use App\Http\Controllers\API\v1\MeetingController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// API v1 Routes
Route::prefix('v1')->group(function () {
    Route::middleware(['throttle:api'])->group(function () {
        Route::post('register', [AuthController::class, 'register']);
        Route::post('login', [AuthController::class, 'login']);
    });

    
    Route::middleware(['throttle:meeting-auth'])->group(function () {
        Route::post('cross-auth/meeting', [AuthController::class, 'handleMeetingAuth']);
    });
    
    // Authenticated routes
    Route::middleware(['auth:sanctum', 'throttle:api'])->group(function () {
        Route::post('logout', [AuthController::class, 'logout']);
    });
});

Route::prefix('v1')->middleware(['auth:sanctum'])->group(function () {
    Route::post('meetings', [MeetingController::class, 'createMeetingApi']);
    Route::put('meetings/{id}', [MeetingController::class, 'editMeetingApi']);
    Route::delete('meetings/{id}', [MeetingController::class, 'deleteMeetingApi']);
});