import * as flatbuffers from 'flatbuffers';
import type { RtpCapabilities, RouterRtpCapabilities, RouterRtpCodecCapability, RtpParameters } from './rtpParametersTypes';
import type { SctpStreamParameters } from './sctpParametersTypes';
export type RtpCodecsEncodingsMapping = {
    codecs: {
        payloadType: number;
        mappedPayloadType: number;
    }[];
    encodings: {
        ssrc?: number;
        rid?: string;
        scalabilityMode?: string;
        mappedSsrc: number;
    }[];
};
/**
 * Validates RtpCapabilities. It may modify given data by adding missing
 * fields with default values.
 * It throws if invalid.
 */
export declare function validateRtpCapabilities(caps: RtpCapabilities | RouterRtpCapabilities): void;
/**
 * Validates RtpParameters. It may modify given data by adding missing
 * fields with default values.
 * It throws if invalid.
 */
export declare function validateRtpParameters(params: RtpParameters): void;
/**
 * Validates SctpStreamParameters. It may modify given data by adding missing
 * fields with default values.
 * It throws if invalid.
 */
export declare function validateSctpStreamParameters(params: SctpStreamParameters): void;
/**
 * Generate RTP capabilities for the Router based on the given media codecs and
 * mediasoup supported RTP capabilities.
 */
export declare function generateRouterRtpCapabilities(mediaCodecs?: RouterRtpCodecCapability[]): RtpCapabilities;
/**
 * Get a mapping of codec payloads and encodings of the given Producer RTP
 * parameters as values expected by the Router.
 *
 * It may throw if invalid or non supported RTP parameters are given.
 */
export declare function getProducerRtpParametersMapping(params: RtpParameters, caps: RtpCapabilities): RtpCodecsEncodingsMapping;
/**
 * Generate RTP parameters to be internally used by Consumers given the RTP
 * parameters of a Producer and the RTP capabilities of the Router.
 */
export declare function getConsumableRtpParameters(kind: string, params: RtpParameters, caps: RtpCapabilities, rtpMapping: RtpCodecsEncodingsMapping): RtpParameters;
/**
 * Check whether the given RTP capabilities can consume the given Producer.
 */
export declare function canConsume(consumableParams: RtpParameters, caps: RtpCapabilities): boolean;
/**
 * Generate RTP parameters for a specific Consumer.
 *
 * It reduces encodings to just one and takes into account given RTP
 * capabilities to reduce codecs, codecs' RTCP feedback and header extensions,
 * and also enables or disables RTX.
 */
export declare function getConsumerRtpParameters({ consumableRtpParameters, remoteRtpCapabilities, pipe, enableRtx, }: {
    consumableRtpParameters: RtpParameters;
    remoteRtpCapabilities: RtpCapabilities;
    pipe: boolean;
    enableRtx: boolean;
}): RtpParameters;
/**
 * Generate RTP parameters for a pipe Consumer.
 *
 * It keeps all original consumable encodings and removes support for BWE. If
 * enableRtx is false, it also removes RTX and NACK support.
 */
export declare function getPipeConsumerRtpParameters({ consumableRtpParameters, enableRtx, }: {
    consumableRtpParameters: RtpParameters;
    enableRtx: boolean;
}): RtpParameters;
export declare function serializeRtpMapping(builder: flatbuffers.Builder, rtpMapping: RtpCodecsEncodingsMapping): number;
//# sourceMappingURL=ortc.d.ts.map