<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(getSelectedLanguage()->direction); ?>"
    data-bs-theme-base="neutral" data-bs-theme="<?php echo e(getThemeFromSession()); ?>">

<head>
    <?php echo $__env->make('include.layouts.common.head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <meta name="description" content="<?php echo $__env->yieldContent('description'); ?>" />

    <link href="<?php echo e(asset('/css/home.css')); ?>" rel="stylesheet" />
    <style>
        <?php echo getSetting('CUSTOM_CSS'); ?>

    </style>
    <?php echo getSetting('CUSTOM_JS'); ?>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body>
    <?php echo $__env->make('include.user.toast', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->yieldContent('home-content'); ?>

    <?php echo $__env->make('include.layouts.common.body', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script>
        const cookieConsent = "<?php echo e(getSetting('COOKIE_CONSENT')); ?>";
        const socialInvitation = `<?php echo e(getSetting('SOCIAL_INVITATION')); ?>`;
        const googleAnalyticsTrackingId = "<?php echo e(getSetting('GOOGLE_ANALYTICS_ID')); ?>";

        const languages = {
            no_meeting: "<?php echo e(__('The meeting does not exist')); ?>",
        }
    </script>

    <script src="<?php echo e(asset('/js/main.js?version=') . getVersion()); ?>"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /www/wwwroot/skweela_net/resources/views/layouts/welcome.blade.php ENDPATH**/ ?>