<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(getSelectedLanguage()->direction); ?>"
    data-bs-theme-base="neutral" data-bs-theme="<?php echo e(getThemeFromSession()); ?>">

<head>
    <?php echo $__env->make('include.layouts.common.head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <link href="<?php echo e(asset('/css/custom.css')); ?>" rel="stylesheet" />

    <?php echo $__env->yieldContent('styles'); ?>

    <style>
        <?php echo getSetting('CUSTOM_CSS'); ?>

    </style>
    <?php echo getSetting('CUSTOM_JS'); ?>

</head>

<body>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('include.cookie', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('include.user.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
       
    <?php echo $__env->make('include.layouts.common.body', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script>
        const cookieConsent = "<?php echo e(getSetting('COOKIE_CONSENT')); ?>";
        const socialInvitation = `<?php echo e(getSetting('SOCIAL_INVITATION')); ?>`;
        const googleAnalyticsTrackingId = "<?php echo e(getSetting('GOOGLE_ANALYTICS_ID')); ?>";

        const languages = {
            error_occurred: "<?php echo e(__('An error occurred, please try again')); ?>",
            data_updated: "<?php echo e(__('Data updated successfully')); ?>",
            no_meeting: "<?php echo e(__('The meeting does not exist')); ?>",
            meeting_created: "<?php echo e(__('The meeting has been created')); ?>",
            confirmation: "<?php echo e(__('Are you sure?')); ?>",
            meeting_deleted: "<?php echo e(__('The meeting has been deleted')); ?>",
            link_copied: "<?php echo e(__('Meeting link has been copied to the clipboard')); ?>",
            meeting_updated: "<?php echo e(__('The meeting has been updated')); ?>",
            sending_invite: "<?php echo e(__('Sending the invitation')); ?>",
            inviteMessage: "<?php echo e(__('Hey there! Join me for a meeting at this link')); ?>",
            no_session: "<?php echo e(__('Could not get the session details')); ?>",
            kicked: "<?php echo e(__('You have been kicked out of the meeting')); ?>",
            uploading: "<?php echo e(__('Uploading the file')); ?>",
            meeting_ended: "<?php echo e(__('Meeting ended')); ?>",
            cant_connect: "<?php echo e(__('Could not connect to the server, please try again later')); ?>",
            invalid_password: "<?php echo e(__('The password is invalid')); ?>",
            no_device: "<?php echo e(__('Could not get the devices, please check the permissions and try again. Error')); ?>",
            approve: "<?php echo e(__('Approve')); ?>",
            decline: "<?php echo e(__('Decline')); ?>",
            request_join_meeting: "<?php echo e(__('Request to join the meeting')); ?>",
            request_declined: "<?php echo e(__('Your request has been declined by the moderator')); ?>",
            double_click: "<?php echo e(__('Double click on the video to make it fullscreen')); ?>",
            single_click: "<?php echo e(__('Single click on the video to turn picture-in-picture mode on')); ?>",
            error_message: "<?php echo e(__('An error occurred')); ?>",
            kick_user: "<?php echo e(__('Kick this user')); ?>",
            participant_joined: "<?php echo e(__('A participant has joined the meeting')); ?>",
            confirmation_kick: "<?php echo e(__('Are you sure you want to kick this user')); ?>",
            participant_left: "<?php echo e(__('A participant has left the meeting')); ?>",
            camera_on: "<?php echo e(__('Camera has been turned on')); ?>",
            camera_off: "<?php echo e(__('Camera has been turned off')); ?>",
            mic_unmute: "<?php echo e(__('Mic has been unmute')); ?>",
            mic_mute: "<?php echo e(__('Mic has been muted')); ?>",
            no_video: "<?php echo e(__('The video is not playing or has no video track')); ?>",
            no_pip: "<?php echo e(__('Picture-in-picture mode is not supported in this browser')); ?>",
            link_copied: "<?php echo e(__('The meeting invitation link has been copied to the clipboard')); ?>",
            cant_share_screen: "<?php echo e(__('Could not share the screen, please check the permissions and try again')); ?>",
            max_file_size: "<?php echo e(__('Maximum file size allowed (MB)')); ?>",
            view_file: "<?php echo e(__('View File')); ?>",
            hand_raised: "<?php echo e(__('Hand raised')); ?>",
            hand_raised_self: "<?php echo e(__('You raised hand')); ?>",
            your_screen: "<?php echo e(__('Your screen')); ?>",
            not_started: "<?php echo e(__('The meeting has not been started yet')); ?>",
            meeting_full: "<?php echo e(__('The meeting is full')); ?>",
            please_wait: "<?php echo e(__('Please wait while the moderator check your request')); ?>",
            request_record_meeting: "<?php echo e(__('Request to record the meeting')); ?>",
            request_screenshare: "<?php echo e(__('Request to start screen sharing')); ?>",
            record_request_declined: "<?php echo e(__('Your recording request was not approved')); ?>",
            screenshare_request_declined: "<?php echo e(__('Your screen share request was not approved')); ?>",
            feature_not_supported: "<?php echo e(__('This feature is not yet supported in your browser')); ?>",
            feature_not_available: "<?php echo e(__('This feature is not available in the current meeting plan')); ?>",
            password: "<?php echo e(__('Password: ')); ?>",
            calendar_check: "<?php echo e(__('Please set a date and time')); ?>",
            recording_started: "<?php echo e(__('The recording has been started')); ?>",
            token_copied: "<?php echo e(__('API Token has been copied to the clipboard')); ?>",
            screen: "<?php echo e(__('Screen-')); ?>",
            checking_mic_permission: "<?php echo e(__('Checking microphone permission')); ?>",
            checking_cam_permission: "<?php echo e(__('Checking camera permission')); ?>",
            click_allow: "<?php echo e(__('Click \"Allow\"')); ?>",
            personal_link_copied: "<?php echo e(__('Your personal meeting link has been copied to the clipboard')); ?>",
            you_muted: "<?php echo e(__('You muted all the participants')); ?>",
            you_unmuted: "<?php echo e(__('You unmuted all the participants')); ?>",
            mic_muted_moderator: "<?php echo e(__('Mic has been muted by the moderator')); ?>",
            mic_unmuted_moderator: "<?php echo e(__('Mic has been unmuted by the moderator')); ?>",
            camera_off_moderator: "<?php echo e(__('Camera has been turned off by the moderator')); ?>",
            camera_on_moderator: "<?php echo e(__('Camera has been turned on by the moderator')); ?>",
            moderator: "<?php echo e(__('Moderator')); ?>",
            moderator_updated: "<?php echo e(__('The moderator has been updated. New moderator: ')); ?>",
            make_moderator: "<?php echo e(__('Make Moderator')); ?>",
            you_moderator: "<?php echo e(__('You are now the moderator')); ?>",
            moderator_confirm: "<?php echo e(__('Are you sure you want to switch the moderator right? This action can not be undone')); ?>",
            api_token_copied: "<?php echo e(__('Api Token copied successfully.')); ?>",
            copied_text: "<?php echo e(__('Copied')); ?>",
            embed_code: "<?php echo e(__('Embed Code')); ?>",
            copy_link: "<?php echo e(__('Copy link')); ?>",
            just_now: "<?php echo e(__('Just Now')); ?>",
            online: "<?php echo e(__('Back online')); ?>",
            offline: "<?php echo e(__('You are offline')); ?>",
            turn_on_mic: "<?php echo e(__('Turn on mic')); ?>",
            turn_off_mic: "<?php echo e(__('Turn off mic')); ?>",
            turn_on_cam: "<?php echo e(__('Turn on cam')); ?>",
            turn_off_cam: "<?php echo e(__('Turn off cam')); ?>",
            mute_all: "<?php echo e(__('Mute All')); ?>",
            unmute_all: "<?php echo e(__('Unmute All')); ?>",
            meeting_ending: "<?php echo e(__('The meeting will end in one minute')); ?>",
            message_deepSeek: "<?php echo e(__('Message DeepSeek')); ?>",
            start: "<?php echo e(__('Start')); ?>"
        }
    </script>
   
    <script src="<?php echo e(asset('/js/main.js?version=') . getVersion()); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>
</body>
</html>
<?php /**PATH /www/wwwroot/skweela_net/resources/views/layouts/app.blade.php ENDPATH**/ ?>