<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(getSelectedLanguage()->direction); ?>"
    data-bs-theme-base="neutral" data-bs-theme="<?php echo e(getThemeFromSession()); ?>">

<head>
    <?php echo $__env->make('include.layouts.common.head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <link href="<?php echo e(asset('/css/auth.css')); ?>" rel="stylesheet" />

    <style>
        [data-bs-theme=light] .navbar-brand-autodark .navbar-brand-image {
            filter: brightness(1) invert(1);
        }
    </style>

    <?php echo $__env->yieldContent('styles'); ?>

    <style>
        <?php echo getSetting('CUSTOM_CSS'); ?>

    </style>
    <?php echo getSetting('CUSTOM_JS'); ?>


</head>

<body>
    <?php echo $__env->yieldContent('content'); ?>

    <?php echo $__env->make('include.layouts.common.body', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script>
        const cookieConsent = "<?php echo e(getSetting('COOKIE_CONSENT')); ?>";
        const googleAnalyticsTrackingId = "<?php echo e(getSetting('GOOGLE_ANALYTICS_ID')); ?>";
        const socialInvitation = `<?php echo e(getSetting('SOCIAL_INVITATION')); ?>`;
    </script>

    <script src="<?php echo e(asset('/js/main.js?version=') . getVersion()); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH /www/wwwroot/skweela_net/resources/views/layouts/auth.blade.php ENDPATH**/ ?>