
<?php $__env->startSection('title', $pageTitle); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('include.admin.toast', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-xl">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <?php echo $__env->make('include.admin.breadcrumbs', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto me-3">
                        <div class="btn-list">
                            <span class="d-sm-inline">
                                <a href="<?php echo e(route('admin.page.create')); ?>" class="btn btn-primary btn-5">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon me-0" width="24" height="24"
                                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                        stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M12 5l0 14" />
                                        <path d="M5 12l14 0" />
                                    </svg>
                                    <span class="d-none d-sm-inline-block"><?php echo e(__('Create New')); ?>

                                </a>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-xl">
                <div class="accordion mb-3" id="pageSearch">
                    <div class="accordion-item">
                        <h4 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#pageSearchForm" aria-expanded="true">
                                <?php echo e(__('Search')); ?>

                            </button>
                        </h4>
                        <div id="pageSearchForm"
                            class="accordion-collapse collapse <?php if($isFiltered): ?> show <?php endif; ?>"
                            data-bs-parent="#pageSearch">
                            <div class="accordion-body pt-0">
                                <?php echo $__env->make('admin.page.search', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="table-responsive">
                        <table class="table card-table table-vcenter text-nowrap datatable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('SR No')); ?></th>
                                    <th><?php echo e(__('Title')); ?></th>
                                    <th><?php echo e(__('Slug')); ?></th>
                                    <th><?php echo e(__('Show in footer')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($pages->firstItem() + $loop->index); ?></td>
                                        <td><?php echo e($page->title); ?></td>
                                        <td><?php echo e($page->slug); ?></td>
                                        <td><?php echo e(ucfirst($page->footer)); ?></td>
                                        <td>
                                            <a href = "<?php echo e(route('admin.page.edit', $page->id)); ?>" class="btn">
                                                <?php echo e(__('Edit')); ?>

                                            </a>
                                            <a href = "<?php echo e(route('admin.page.destroy', $page->id)); ?>" class="btn"
                                                onclick="return confirm('Are you sure you want to delete this Page?')">
                                                <?php echo e(__('Delete')); ?>

                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td><?php echo e(__('No Records Found')); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php if($pages->hasPages()): ?>
                        <div class="mt-2 ms-2">
                            <?php echo e($pages->links('pagination::bootstrap-5')); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/skweela_net/resources/views/admin/page/index.blade.php ENDPATH**/ ?>