
<?php $__env->startSection('title', __('Meta title')); ?>
<?php $__env->startSection('description', __('Meta description')); ?>
<?php $__env->startSection('home-content'); ?>
    <div class="page jm-homepage">
        <!-- Modern Glass Header -->
        <?php echo $__env->make('include.user.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <!-- Modern Hero Section - Enhanced Design -->
        <section class="jm-hero-section">
            <div class="hero-container">
                <div class="hero-content-wrapper">
                    <div class="hero-text-content">
                        <div class="hero-badge">
                            <i class="fas fa-bolt"></i>
                            <span><?php echo e(__('Next Generation Video Conferencing')); ?></span>
                        </div>
                        <h1 class="hero-title">
                            <?php echo e(__('Meet.')); ?> <span class="text-gradient"><?php echo e(__('Collaborate.')); ?></span> <?php echo e(__('Succeed.')); ?>

                        </h1>
                        <p class="hero-subtitle">
                            <?php echo e(__('Experience crystal-clear video meetings with enterprise-grade security and intuitive features')); ?>

                        </p>
                        
                        <!-- Join Meeting Form -->
                        <div class="hero-action-area">
                            <form id="meetingDashboard" class="join-form">
                                <div class="form-input-group">
                                    <div class="input-icon">
                                        <i class="fas fa-keyboard"></i>
                                    </div>
                                    <input type="text" class="form-input" maxlength="9" id="conferenceId"
                                        name="id" placeholder="<?php echo e(__('Enter Meeting ID')); ?>" required>
                                    <button type="submit" class="join-button">
                                        <?php echo e(__('Join Now')); ?>

                                        <i class="fas fa-arrow-right ml-2"></i>
                                    </button>
                                </div>
                            </form>
                            
                            <?php if(getSetting('AUTH_MODE') == 'enabled'): ?>
                            <div class="host-option">
                                <span><?php echo e(__('Want to host?')); ?></span>
                                <a href="<?php echo e(route('dashboard')); ?>" class="host-link">
                                    <?php echo e(__('Start a meeting')); ?>

                                    <i class="fas fa-arrow-right"></i>
                                </a>
                            </div>
                            <?php endif; ?>
                            
                            <div class="hero-features-grid">
                                <div class="feature-item">
                                    <div class="feature-icon">
                                        <i class="fas fa-shield-alt"></i>
                                    </div>
                                    <span><?php echo e(__('Secure')); ?></span>
                                </div>
                                <div class="feature-item">
                                    <div class="feature-icon">
                                        <i class="fas fa-magic"></i>
                                    </div>
                                    <span><?php echo e(__('Easy to use')); ?></span>
                                </div>
                                <div class="feature-item">
                                    <div class="feature-icon">
                                        <i class="fas fa-bolt"></i>
                                    </div>
                                    <span><?php echo e(__('Instant join')); ?></span>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Trust Indicators -->
                        <div class="trust-indicators">
                            <div class="trust-item">
                                <i class="fas fa-lock"></i>
                                <span><?php echo e(__('End-to-End Encryption')); ?></span>
                            </div>
                            <div class="trust-item">
                                <i class="fas fa-users"></i>
                                <span><?php echo e(__('1000+ Daily Users')); ?></span>
                            </div>
                            <div class="trust-item">
                                <i class="fas fa-star"></i>
                                <span><?php echo e(__('5-Star Rating')); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="hero-visual-content">
                        <div class="meeting-visual">
                            <div class="screen-preview">
                                <div class="screen-header">
                                    <div class="app-logo">
                                        <i class="fas fa-video"></i>
                                    </div>
                                    <div class="meeting-title"><?php echo e(__('Team Meeting')); ?></div>
                                    <div class="meeting-time">12:30</div>
                                </div>
                                <div class="screen-content">
                                    <div class="main-participant">
                                        <div class="participant-avatar large"></div>
                                        <div class="participant-name"><?php echo e(__('John Doe')); ?></div>
                                        <div class="participant-status speaking"></div>
                                    </div>
                                    <div class="participants-grid">
                                        <div class="participant">
                                            <div class="participant-avatar"></div>
                                            <div class="participant-status active"></div>
                                        </div>
                                        <div class="participant">
                                            <div class="participant-avatar"></div>
                                            <div class="participant-status active"></div>
                                        </div>
                                        <div class="participant">
                                            <div class="participant-avatar"></div>
                                            <div class="participant-status active"></div>
                                        </div>
                                        <div class="participant">
                                            <div class="participant-avatar"></div>
                                            <div class="participant-status"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="screen-controls">
                                    <div class="control-btn">
                                        <i class="fas fa-microphone"></i>
                                    </div>
                                    <div class="control-btn">
                                        <i class="fas fa-video"></i>
                                    </div>
                                    <div class="control-btn">
                                        <i class="fas fa-desktop"></i>
                                    </div>
                                    <div class="control-btn active">
                                        <i class="fas fa-comment"></i>
                                    </div>
                                    <div class="control-btn end">
                                        <i class="fas fa-phone-slash"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="floating-shape shape-1"></div>
                            <div class="floating-shape shape-2"></div>
                            <div class="floating-shape shape-3"></div>
                            
                            <!-- Feature Highlights -->
                            <div class="feature-highlights">
                                <div class="highlight-card">
                                    <div class="highlight-icon">
                                        <i class="fas fa-video"></i>
                                    </div>
                                    <div class="highlight-text">
                                        <div class="highlight-title"><?php echo e(__('HD Quality')); ?></div>
                                        <div class="highlight-desc"><?php echo e(__('Crystal clear video')); ?></div>
                                    </div>
                                </div>
                                <div class="highlight-card">
                                    <div class="highlight-icon">
                                        <i class="fas fa-comments"></i>
                                    </div>
                                    <div class="highlight-text">
                                        <div class="highlight-title"><?php echo e(__('Live Chat')); ?></div>
                                        <div class="highlight-desc"><?php echo e(__('Real-time messaging')); ?></div>
                                    </div>
                                </div>
                                <div class="highlight-card">
                                    <div class="highlight-icon">
                                        <i class="fas fa-file-alt"></i>
                                    </div>
                                    <div class="highlight-text">
                                        <div class="highlight-title"><?php echo e(__('File Sharing')); ?></div>
                                        <div class="highlight-desc"><?php echo e(__('Share documents instantly')); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php echo $__env->make('include.user.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Font Awesome Import */
@import url('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css');

/* Color Variables */
:root, [data-bs-theme=light] {
  --tblr-primary: #007bff;
  --tblr-secondary: #ce0aad;
  --tblr-primary-light: rgba(0, 123, 255, 0.1);
  --tblr-secondary-light: rgba(206, 10, 173, 0.1);
  --hero-gradient: linear-gradient(135deg, var(--tblr-primary), var(--tblr-secondary));
  --trust-color: #4ade80;
}
[data-bs-theme=dark] {
  --tblr-primary: #3a8cff;
  --tblr-secondary: #e012c2;
  --tblr-primary-light: rgba(58, 140, 255, 0.1);
  --tblr-secondary-light: rgba(224, 18, 194, 0.1);
  --hero-gradient: linear-gradient(135deg, var(--tblr-primary), var(--tblr-secondary));
  --trust-color: #4ade80;
}

/* Modern Hero Section - Enhanced Design */
.jm-hero-section {
    padding: 5rem 0;
    min-height: 90vh;
    display: flex;
    align-items: center;
    z-index: -9999;
    background-color: var(--tblr-body-bg);
}

.hero-container {
    width: 100%;
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 2rem;
}

.hero-content-wrapper {
    display: flex;
    flex-wrap: wrap;
    align-items: center;
    gap: 3rem;
}

.hero-text-content {
    flex: 1 1 45%;
    min-width: 300px;
    position: relative;
    z-index: 2;
}

.hero-visual-content {
    flex: 1 1 45%;
    min-width: 300px;
    position: relative;
}

.hero-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    background: var(--tblr-primary-light);
    color: var(--tblr-primary);
    padding: 0.5rem 1rem;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    margin-bottom: 1.5rem;
    border: 1px solid rgba(0, 123, 255, 0.2);
}

.hero-badge i {
    font-size: 0.9rem;
}

.hero-title {
    font-size: 3.5rem;
    font-weight: 800;
    line-height: 1.2;
    margin-bottom: 1.5rem;
    color: var(--tblr-body-color);
}

.text-gradient {
    background: var(--hero-gradient);
    -webkit-background-clip: text;
    background-clip: text;
    color: transparent;
    display: inline-block;
}

.hero-subtitle {
    font-size: 1.25rem;
    color: var(--tblr-secondary-text);
    margin-bottom: 2.5rem;
    max-width: 500px;
    line-height: 1.6;
}

/* Join Form Styles */
.join-form {
    max-width: 500px;
}

.form-input-group {
    display: flex;
    align-items: center;
    background: var(--tblr-body-bg);
    border-radius: 12px;
    padding: 0.5rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    border: 1px solid var(--tblr-border-color);
    transition: all 0.3s ease;
}

.form-input-group:focus-within {
    border-color: var(--tblr-primary);
    box-shadow: 0 10px 30px rgba(0, 123, 255, 0.2);
}

.input-icon {
    padding: 0 0.75rem;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--tblr-secondary);
}

.form-input {
    flex: 1;
    border: none;
    padding: 0.75rem 0;
    background: transparent;
    font-size: 1rem;
    color: var(--tblr-body-color);
}

.form-input:focus {
    outline: none;
    box-shadow: none;
}

.join-button {
    background: var(--hero-gradient);
    color: white;
    border: none;
    padding: 0.75rem 1.5rem;
    border-radius: 8px;
    font-weight: 600;
    font-size: 1rem;
    cursor: pointer;
    display: flex;
    align-items: center;
    transition: all 0.3s ease;
}

.join-button:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(206, 10, 173, 0.3);
}

/* Host Link */
.host-option {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin-top: 1.5rem;
    font-size: 0.95rem;
    color: var(--tblr-secondary-text);
}

.host-link {
    color: var(--tblr-secondary);
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    transition: all 0.3s ease;
}

.host-link:hover {
    color: var(--tblr-primary);
}

.host-link i {
    margin-left: 0.25rem;
    font-size: 0.8rem;
}

/* Features Grid */
.hero-features-grid {
    display: flex;
    gap: 1.5rem;
    margin-top: 2.5rem;
    flex-wrap: wrap;
}

.feature-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.95rem;
    color: var(--tblr-body-color);
}

.feature-icon {
    width: 32px;
    height: 32px;
    border-radius: 8px;
    background: var(--tblr-primary-light);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--tblr-primary);
}

.feature-icon i {
    font-size: 0.9rem;
}

/* Trust Indicators */
.trust-indicators {
    display: flex;
    flex-wrap: wrap;
    gap: 1.5rem;
    margin-top: 2.5rem;
}

.trust-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.9rem;
    color: var(--tblr-secondary-text);
}

.trust-item i {
    color: var(--trust-color);
}

/* Meeting Visual */
.meeting-visual {
    position: relative;
    width: 100%;
    max-width: 600px;
    margin: 0 auto;
}

.screen-preview {
    position: relative;
    background: var(--tblr-body-bg);
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
    border: 1px solid var(--tblr-border-color);
    z-index: 2;
    transform: perspective(1000px) rotateY(-10deg);
}

.screen-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 1rem 1.5rem;
    border-bottom: 1px solid var(--tblr-border-color);
}

.app-logo {
    width: 32px;
    height: 32px;
    border-radius: 8px;
    background: var(--hero-gradient);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.meeting-title {
    font-weight: 600;
    color: var(--tblr-body-color);
}

.meeting-time {
    font-size: 0.85rem;
    color: var(--tblr-secondary-text);
}

.screen-content {
    background: var(--tblr-body-bg);
    height: 300px;
    overflow: hidden;
    position: relative;
    padding: 1rem;
}

.main-participant {
    position: absolute;
    top: 1rem;
    left: 1rem;
    right: 1rem;
    height: 180px;
    background: var(--tblr-primary-light);
    border-radius: 8px;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
}

.participant-avatar {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: var(--tblr-primary);
    margin-bottom: 0.5rem;
}

.participant-avatar.large {
    width: 80px;
    height: 80px;
}

.participant-name {
    font-weight: 600;
    color: var(--tblr-body-color);
}

.participant-status {
    width: 10px;
    height: 10px;
    border-radius: 50%;
    background: #6c757d;
    position: absolute;
    bottom: 1rem;
    right: 1rem;
}

.participant-status.active {
    background: var(--trust-color);
}

.participant-status.speaking {
    background: #f59e0b;
    width: 40px;
    height: 4px;
    border-radius: 2px;
    bottom: auto;
    top: 1rem;
    right: auto;
    left: 1rem;
    animation: pulse 1.5s infinite;
}

@keyframes pulse {
    0% { opacity: 0.6; }
    50% { opacity: 1; }
    100% { opacity: 0.6; }
}

.participants-grid {
    position: absolute;
    bottom: 0rem;
    left: 1rem;
    right: 1rem;
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 0.55rem;
}

.participant {
    position: relative;
    aspect-ratio: 1/1;
}

.participant .participant-avatar {
    width: 90%;
    height: 90%;
    border-radius: 8px;
    position: relative;
}

.participant .participant-status {
    position: absolute;
    width: 12px;
    height: 12px;
    border: 2px solid var(--tblr-body-bg);
}

.screen-controls {
    display: flex;
    justify-content: space-around;
    padding: 1rem;
    background: var(--tblr-secondary-bg);
    border-top: 1px solid var(--tblr-border-color);
}

.control-btn {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--tblr-body-color);
    transition: all 0.2s ease;
}

.control-btn:hover {
    background: var(--tblr-tertiary-bg);
}

.control-btn.active {
    background: var(--tblr-primary-light);
    color: var(--tblr-primary);
}

.control-btn.end {
    background: #ef4444;
    color: white;
}

/* Floating Shapes */
.floating-shape {
    position: absolute;
    border-radius: 50%;
    filter: blur(40px);
    opacity: 0.6;
    z-index: 1;
}

.shape-1 {
    position: absolute;
    width: 200px;
    height: 200px;
    background: var(--tblr-primary);
    top: -50px;
    right: -50px;
    animation: float 8s ease-in-out infinite;
}

.shape-2 {
    width: 300px;
    height: 300px;
    background: var(--tblr-secondary);
    bottom: -100px;
    left: -100px;
    animation: float 10s ease-in-out infinite reverse;
}

.shape-3 {
    width: 150px;
    height: 150px;
    background: var(--tblr-primary);
    bottom: 50px;
    right: 50px;
    animation: float 6s ease-in-out infinite 2s;
}

/* Feature Highlights */
.feature-highlights {
    display: flex;
    flex-direction: column;
    gap: 1rem;
    margin-top: 2rem;
    position: relative;
    z-index: 3;
}

.highlight-card {
    background: var(--tblr-body-bg);
    border-radius: 12px;
    padding: 1rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.05);
    border: 1px solid var(--tblr-border-color);
    transition: all 0.3s ease;
}

.highlight-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
}

.highlight-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    background: var(--tblr-primary-light);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--tblr-primary);
}

.highlight-text {
    flex: 1;
}

.highlight-title {
    font-weight: 600;
    color: var(--tblr-body-color);
    font-size: 0.95rem;
}

.highlight-desc {
    font-size: 0.8rem;
    color: var(--tblr-secondary-text);
}

/* Animations */
@keyframes float {
    0% { transform: translate(0, 0) rotate(0deg); }
    50% { transform: translate(20px, -20px) rotate(5deg); }
    100% { transform: translate(0, 0) rotate(0deg); }
}

/* Responsive Design */
@media (max-width: 992px) {
    .hero-title {
        font-size: 2.75rem;
    }
    
    .hero-content-wrapper {
        flex-direction: column;
        gap: 4rem;
    }
    
    .hero-text-content, .hero-visual-content {
        flex: 1 1 100%;
        width: 100%;
    }
    
    .feature-highlights {
        flex-direction: row;
        flex-wrap: wrap;
    }
    
    .highlight-card {
        flex: 1 1 calc(33.333% - 1rem);
    }
}

@media (max-width: 768px) {
    .hero-title {
        font-size: 2.25rem;
    }
    
    .hero-subtitle {
        font-size: 1.1rem;
    }
    
    .jm-hero-section {
        padding: 3rem 0;
        min-height: auto;
    }
    
    .hero-features-grid {
        gap: 1rem;
    }
    
    .screen-preview {
        transform: none;
    }
    
    .trust-indicators {
        justify-content: center;
    }
    
    .feature-highlights {
        flex-direction: column;
    }
    
    .highlight-card {
        flex: 1 1 100%;
    }
    .shape-1{
        position: relative;
    }
}

@media (max-width: 480px) {
    .hero-title {
        font-size: 2rem;
    }
    
    .form-input-group {
        flex-direction: column;
        background: transparent;
        box-shadow: none;
        padding: 0;
        gap: 0.75rem;
    }
    
    .form-input {
        width: 100%;
        padding: 0.75rem 1rem;
        background: var(--tblr-body-bg);
        border-radius: 8px;
        border: 1px solid var(--tblr-border-color);
    }
    
    .join-button {
        width: 100%;
        justify-content: center;
    }
    
    .host-option {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .trust-indicators {
        flex-direction: column;
        gap: 0.75rem;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Animation trigger for hero section
    const heroSection = document.querySelector('.jm-hero-section');
    if (heroSection) {
        heroSection.classList.add('loaded');
    }
    
    // Form submission handling
    const meetingForm = document.getElementById('meetingDashboard');
    if (meetingForm) {
        meetingForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const meetingId = document.getElementById('conferenceId').value;
            if (meetingId) {
                // Add your form submission logic here
                console.log('Joining meeting with ID:', meetingId);
                // Example: window.location.href = '/meeting/' + meetingId;
            }
        });
    }
    
    // Add interactive hover effects for feature cards
    const highlightCards = document.querySelectorAll('.highlight-card');
    highlightCards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.querySelector('.highlight-icon').style.transform = 'scale(1.1)';
        });
        
        card.addEventListener('mouseleave', function() {
            this.querySelector('.highlight-icon').style.transform = 'scale(1)';
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.welcome', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/skweela_net/resources/views/home.blade.php ENDPATH**/ ?>