<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(getSelectedLanguage()->direction); ?>"
    data-bs-theme-base="neutral" data-bs-theme="<?php echo e(getThemeFromSession()); ?>">

<head>
    <?php echo $__env->make('include.layouts.common.head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <style>
        :root {
            --tblr-primary: #7453f0 !important;
            --tblr-primary-rgb: 116, 83, 240 !important;
        }

        [data-bs-theme=light] .navbar-brand-autodark .navbar-brand-image {
            filter: brightness(1) invert(1);
        }
    </style>
    <link href="<?php echo e(asset('/css/admin.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('/css/bootstrap-icons.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('/css/quill.snow.css')); ?>" rel="stylesheet">

    <?php echo $__env->yieldContent('styles'); ?>
</head>

<body>
    <div class="page">
        <?php echo $__env->make('include.admin.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make('include.admin.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <div class="page-wrapper">
            <?php echo $__env->yieldContent('content'); ?>
            <?php echo $__env->make('include.admin.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    </div>

    <?php echo $__env->make('include.layouts.common.body', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script>
        const translations = {
            paid_pie_chart: "<?php echo e(__('Paid')); ?>",
            free_pie_chart: "<?php echo e(__('Free')); ?>",
            jan: "<?php echo e(__('Jan')); ?>",
            feb: "<?php echo e(__('Feb')); ?>",
            mar: "<?php echo e(__('Mar')); ?>",
            apr: "<?php echo e(__('Apr')); ?>",
            may: "<?php echo e(__('May')); ?>",
            jun: "<?php echo e(__('June')); ?>",
            jul: "<?php echo e(__('Jul')); ?>",
            aug: "<?php echo e(__('Aug')); ?>",
            sep: "<?php echo e(__('Sep')); ?>",
            oct: "<?php echo e(__('Oct')); ?>",
            nov: "<?php echo e(__('Nov')); ?>",
            dec: "<?php echo e(__('Dec')); ?>",
            update_available: "<?php echo e(__('An update is available: Version: ')); ?>",
            already_latest_version: "<?php echo e(__('Application is already at latest version. Version: ')); ?>",
            application_updated: "<?php echo e(__('The application has been successfully updated to the latest version')); ?>",
            update_failed: "<?php echo e(__('Update failed. Error: ')); ?>",
            valid_license: "<?php echo e(__('Your license is valid. Type: ')); ?>",
            invalid_license: "<?php echo e(__('Your license is invalid. Error: ')); ?>",
            license_uninstalled: "<?php echo e(__('License uninstalled')); ?>",
            license_uninstalled_failed: "<?php echo e(__('License uninstallation failed. Error: ')); ?>",
            copied_to_clipboard: "<?php echo e(__('Copied to clipboard.')); ?>",
            monthly_income: "<?php echo e(__('Monthly Income')); ?>",
            monthly_user_registered: "<?php echo e(__('Monthly User Registered')); ?>",
            monthly_meetings: "<?php echo e(__('Monthly Meetings')); ?>",
        }
    </script>

    <?php echo $__env->yieldContent('script'); ?>

    <script src="<?php echo e(asset('/js/admin.js?version=') . getVersion()); ?>"></script>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\pro\JupiterMeetPro_V2\resources\views/layouts/admin.blade.php ENDPATH**/ ?>