

<?php $__env->startSection('profile-content'); ?>
    <div class="col-12 col-md-9 d-flex flex-column card-body">
        <h2 class="mb-4"><?php echo e(__('Contacts')); ?></h2>
        <?php echo $__env->make('include.user.message', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <div class="row mb-3 ">
            <div class="col-sm-12">
                <a href="<?php echo e(route('user.profile.contact.create')); ?>"><button class="btn btn-primary"
                        title="<?php echo e(__('Create Contact')); ?>"><?php echo e(__('Create')); ?></button></a>
                <a href="<?php echo e(route('user.profile.contact.import.form')); ?>" style="margin-left:5px;"><button
                        class="btn btn-success" title="<?php echo e(__('Create Contact')); ?>"><?php echo e(__('Import')); ?></button></a>
            </div>
        </div>
        <?php if(count($contacts)): ?>
            <table class="table table-bordered table-striped table-hover">
                <thead>
                    <tr>
                        <th><?php echo e(__('SR No')); ?></th>
                        <th><?php echo e(__('Name')); ?></th>
                        <th><?php echo e(__('Email')); ?></th>
                        <th><?php echo e(__('Created')); ?></th>
                        <th><?php echo e(__('Updated')); ?></th>
                        <th><?php echo e(__('Edit')); ?></th>
                        <th><?php echo e(__('Delete')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($contacts->firstItem() + $loop->index); ?>

                            </td>
                            <td><?php echo e($contact->name); ?></td>
                            <td><?php echo e($contact->email); ?></td>
                            <td><?php echo e($contact->created_at->diffForHumans()); ?>

                            </td>
                            <td><?php echo e($contact->updated_at->diffForHumans()); ?>

                            </td>
                            <td>
                                <a href="<?php echo e(route('user.profile.contact.edit', $contact->id)); ?>">
                                    <button class="btn btn-primary edit-contact" title="<?php echo e(__('Edit')); ?>">
                                        <?php echo e(__('Edit')); ?>

                                    </button>
                                </a>
                            </td>
                            <td>
                                <a href = "<?php echo e(route('user.profile.contact.destroy', $contact->id)); ?>"
                                    class="btn btn btn-danger"
                                    onclick="return confirm('Are you sure you want to delete this contact?')">
                                    <?php echo e(__('Delete')); ?>

                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <?php if($contacts->hasPages()): ?>
                <div class="card-footer">
                    <div class="mt-2 ms-2">
                        <?php echo e($contacts->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <p><?php echo e(__('Your contacts will appear here')); ?></p>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.profile.index', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/skweela_net/resources/views/user/profile/contact/index.blade.php ENDPATH**/ ?>