
<?php $__env->startSection('title', $pageTitle); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('include.admin.toast', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-xl">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <?php echo $__env->make('include.admin.breadcrumbs', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                    <div class="col-auto ms-auto me-3">
                        <div class="btn-list">
                            <span class="d-sm-inline">
                                <a href="<?php echo e(route('export-user', request()->all())); ?>" class="btn hideLoader">
                                    <?php echo e(__('Export')); ?>

                                </a>
                            </span>
                            <span class="d-sm-inline">
                                <a href="<?php echo e(route('admin.user.create')); ?>" class="btn btn-primary btn-5">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon me-0" width="24" height="24"
                                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                        stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M12 5l0 14" />
                                        <path d="M5 12l14 0" />
                                    </svg>
                                    <span class="d-none d-sm-inline-block"><?php echo e(__('Create New')); ?>

                                </a>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-xl">
                <div class="accordion mb-3" id="userSearch">
                    <div class="accordion-item">
                        <h4 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#userSearchForm" aria-expanded="true">
                                <?php echo e(__('Search')); ?>

                            </button>
                        </h4>
                        <div id="userSearchForm"
                            class="accordion-collapse collapse <?php if($isFiltered): ?> show <?php endif; ?>"
                            data-bs-parent="#userSearch">
                            <div class="accordion-body pt-0">
                                <?php echo $__env->make('admin.user.search', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="table-responsive">
                        <table class="table card-table table-vcenter text-nowrap datatable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('SR No')); ?></th>
                                    <th><?php echo e(__('Avatar')); ?></th>
                                    <th><?php echo e(__('First Name')); ?></th>
                                    <th><?php echo e(__('Last Name')); ?></th>
                                    <th><?php echo e(__('Username')); ?></th>
                                    <th><?php echo e(__('Email')); ?></th>
                                    <th><?php echo e(__('Plan')); ?></th>
                                    <th><?php echo e(__('Source')); ?></th>
                                    <th><?php echo e(__('Created Date')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($users->firstItem() + $loop->index); ?></td>
                                        <td>
                                            <?php if($user->avatar): ?>
                                                <span class="avatar"
                                                    style="background-image: url('<?php echo e(asset('storage/avatars/' . $user->avatar)); ?>')">
                                                </span>
                                            <?php else: ?>
                                                <span class="avatar"
                                                    style="background-image: url('<?php echo e(asset('/images/blank.jpeg')); ?>')"></span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-truncate" title="<?php echo e($user->first_name); ?>">
                                            <?php echo e($user->first_name ?? '-'); ?></td>
                                        <td class="text-truncate" title="<?php echo e($user->last_name); ?>">
                                            <?php echo e($user->last_name ?? '-'); ?></td>
                                        <td class="text-truncate" title="<?php echo e($user->username); ?>"><?php echo e($user->username); ?></td>
                                        <td class="text-truncate" title="<?php echo e($user->email); ?>"><?php echo e($user->email); ?></td>
                                        <td>
                                            <select class="form-control dropdown-toggle assignPlanDropdown">
                                                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($plan->id); ?>|<?php echo e($user->id); ?>"
                                                        <?php echo e($plan->id == $user->plan_id ? 'selected' : ''); ?>>
                                                        <?php echo e($plan->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>
                                        <?php if($user->facebook_id): ?>
                                            <td>Facebook</td>
                                        <?php elseif($user->twitter_id): ?>
                                            <td>Twitter</td>
                                        <?php elseif($user->google_id): ?>
                                            <td>Google</td>
                                        <?php elseif($user->linkedin_id): ?>
                                            <td>LinkedIn</td>
                                        <?php else: ?>
                                            <td><?php echo e(__('Register')); ?></td>
                                        <?php endif; ?>

                                        <td><?php echo e($user->created_at->diffForHumans()); ?></td>
                                        <td>
                                            <div class="form-switch">
                                                <input class="form-check-input toggle-user-status" type="checkbox"
                                                    data-id="<?php echo e($user->id); ?>"
                                                    value="<?php echo e($user->status === 'active' ? 'active' : 'inactive'); ?>"
                                                    <?php echo e($user->status === 'active' ? 'checked' : ''); ?>>
                                            </div>
                                        </td>
                                        <td>
                                            <a class="btn" href = "<?php echo e(route('admin.user.destroy', $user->id)); ?>"
                                                onclick="return confirm('Are you sure you want to delete this User?')"
                                                title="<?php echo e(__('Delete')); ?>">
                                                <?php echo e(__('Delete')); ?>

                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td><?php echo e(__('No Records Found')); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php if($users->hasPages()): ?>
                        <div class="mt-2 ms-2">
                            <?php echo e($users->links('pagination::bootstrap-5')); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('/js/litepicker.js')); ?>"></script>
    <script>
        const picker = new Litepicker({
            element: document.getElementById('litepicker'),
            singleMode: false,
            format: 'YYYY/MM/DD',
            autoApply: true,
        });

        $(document).ready(function() {
            $("#clearDate").click(function() {
                $("#litepicker").val("");
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/skweela_net/resources/views/admin/user/index.blade.php ENDPATH**/ ?>