<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', $page); ?>
<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('css/select2.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('/css/tom-select.min.css')); ?>" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: var(--tblr-secondary);
            --secondary: var(--tblr-primary);
            --success: var(--tblr-success);
            --danger: var(--tblr-danger);
            --warning: var(--tblr-warning);
            --info: var(--tblr-info);
            --light: var(--tblr-light);
            --dark: var(--tblr-dark);
            --white: var(--tblr-white);
            --body-bg: var(--tblr-body-bg);
            --body-color: var(--tblr-body-color);
            --border-color: var(--tblr-border-color);
            --border-radius: var(--tblr-border-radius);
            --box-shadow: var(--tblr-box-shadow);
            --font-family: var(--tblr-body-font-family);
            --font-size: var(--tblr-body-font-size);
            --line-height: var(--tblr-body-line-height);
            --primary-bg-subtle: var(--tblr-primary-bg-subtle);
            --primary-text-emphasis: var(--tblr-primary-text-emphasis);
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: var(--font-family);
            font-size: var(--font-size);
            line-height: var(--line-height);
            background-color: var(--body-bg);
            color: var(--body-color);
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .page {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .page-wrapper {
            flex: 1;
            padding: 0.25rem 0;
        }

        .container-xl {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 0.5rem;
        }

        /* Main Layout Structure */
        .dashboard-layout {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }

        /* Header Section */
        .dashboard-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--info) 100%);
            border-radius: var(--border-radius);
            padding: 1rem;
            color: var(--white);
            box-shadow: var(--tblr-box-shadow-lg);
            position: relative;
            overflow: hidden;
        }

        .dashboard-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -10%;
            width: 300px;
            height: 300px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }

        .dashboard-header h1 {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 0.15rem;
            position: relative;
            z-index: 1;
        }

        .dashboard-header p {
            font-size: 0.9rem;
            opacity: 0.9;
            position: relative;
            z-index: 1;
        }

        /* Action Cards */
        .action-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 0.75rem;
            margin-bottom: 0.75rem;
        }

        .action-card {
            background: var(--white);
            border-radius: var(--border-radius);
            padding: 0.75rem;
            box-shadow: var(--box-shadow);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .action-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 3px;
            height: 100%;
            background: var(--secondary);
            transform: scaleY(0);
            transition: transform 0.3s ease;
        }

        .action-card:hover {
            transform: translateY(-2px);
            box-shadow: var(--tblr-box-shadow-lg);
        }

        .action-card:hover::before {
            transform: scaleY(1);
        }

        .action-card-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1rem;
            margin-bottom: 0.5rem;
        }

        .action-card-icon.create {
            background: var(--primary-bg-subtle);
            color: var(--primary);
        }

        .action-card-icon.join {
            background: var(--tblr-success-bg-subtle);
            color: var(--success);
        }

        .action-card-icon.start {
            background: var(--tblr-warning-bg-subtle);
            color: var(--warning);
        }

        .action-card-icon.copy {
            background: var(--tblr-info-bg-subtle);
            color: var(--info);
        }

        .action-card h3 {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 0.2rem;
            color: var(--body-color);
        }

        .action-card p {
            font-size: 0.85rem;
            color: var(--secondary);
            margin-bottom: 0.5rem;
        }

        /* Updated: Action card buttons now use --secondary */
        .action-card .btn {
            background: var(--secondary);
            color: var(--white);
            padding: 0.4rem 0.8rem;
            font-size: 0.85rem;
        }

        .action-card .btn:hover {
            background: var(--primary-text-emphasis);
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(var(--tblr-primary-rgb), 0.3);
        }

        /* Main Content Area */
        .content-area {
            display: flex;
            gap: 0.75rem;
            align-items: stretch;
            height: calc(100vh - 200px);
            min-height: 350px;
        }

        /* Sidebar */
        .sidebar {
            flex: 0 0 280px;
            background: var(--white);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
            display: flex;
            flex-direction: column;
            border: 1px solid #ededed;
        }

        .sidebar-header {
            padding: 0.75rem;
            border-bottom: 1px solid var(--secondary);
            background: var(--light);
        }

        .sidebar-header h2 {
            font-size: 1rem;
            font-weight: 600;
            color: var(--body-color);
            margin-bottom: 0.4rem;
        }

        .search-box {
            position: relative;
        }

        .search-box input {
            width: 100%;
            padding: 0.4rem 0.8rem 0.4rem 1.8rem;
            border: 1px solid var(--secondary);
            border-radius: var(--border-radius);
            background: var(--white);
            color: var(--body-color);
            transition: all 0.3s ease;
            font-size: 0.85rem;
        }

        .search-box input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 2px var(--primary-bg-subtle);
        }

        .search-box i {
            position: absolute;
            left: 0.6rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--secondary);
            font-size: 0.85rem;
        }

        /* Meeting List */
        .meeting-list {
            flex: 1;
            overflow-y: auto;
            padding: 0.5rem;
        }

        .meeting-item {
            background: var(--white);
            border: 1px solid #b3bec7;
            border-radius: var(--border-radius);
            padding: 0.5rem;
            margin-bottom: 0.4rem;
            cursor: pointer;
            transition: all 0.2s ease;
            position: relative;
        }

        .meeting-item:hover {
            border-color: var(--primary);
            box-shadow: 0 1px 4px rgba(var(--tblr-primary-rgb), 0.15);
        }

        .meeting-item.active {
            border-color: var(--primary);
            background: var(--primary-bg-subtle);
        }

        .meeting-item.active::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 3px;
            background: var(--secondary);
            border-radius: var(--border-radius) 0 0 var(--border-radius);
        }

        .meeting-title {
            font-weight: 600;
            font-size: 0.9rem;
            color: var(--body-color);
            margin-bottom: 0.2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .meeting-badge {
            background: var(--secondary);
            color: var(--white);
            padding: 0.1rem 0.3rem;
            border-radius: 1rem;
            font-size: 0.65rem;
            font-weight: 500;
        }

        .meeting-description {
            color: var(--secondary);
            font-size: 0.8rem;
            margin-bottom: 0.4rem;
            line-height: 1.2;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .meeting-meta {
            display: flex;
            align-items: center;
            justify-content: space-between;
            font-size: 0.75rem;
            color: var(--secondary);
        }

        .meeting-id {
            display: flex;
            align-items: center;
            gap: 0.3rem;
        }

        .meeting-time {
            display: flex;
            align-items: center;
            gap: 0.3rem;
        }

        /* Main Content */
        .main-content {
            flex: 1;
            background: var(--white);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
            display: flex;
            flex-direction: column;
            border: 1px solid #ededed;
        }

        .content-header {
            padding: 0.75rem;
            border-bottom: 1px solid var(--secondary);
            background: var(--light);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .content-header h2 {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--body-color);
            margin-bottom: 0;
        }

        .content-body {
            flex: 1;
            padding: 0.75rem;
            overflow-y: auto;
        }

        /* Meeting Details */
        .meeting-details {
            display: grid;
            gap: 0.75rem;
        }

        .detail-card {
            background: var(--light);
            border-radius: var(--border-radius);
            padding: 0.75rem;
        }

        .detail-card h3 {
            font-size: 0.9rem;
            font-weight: 600;
            color: var(--body-color);
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            gap: 0.4rem;
        }

        .detail-item {
            display: flex;
            align-items: flex-start;
            margin-bottom: 0.5rem;
            font-size: 0.85rem;
        }

        .detail-item:last-child {
            margin-bottom: 0;
        }

        .detail-label {
            flex: 0 0 100px;
            font-weight: 500;
            color: var(--secondary);
        }

        .detail-value {
            flex: 1;
            color: var(--body-color);
        }

        /* Action Buttons */
        .action-buttons {
            display: flex;
            gap: 0.5rem;
            margin-top: 1rem;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            gap: 0.4rem;
            padding: 0.4rem 0.8rem;
            border-radius: var(--border-radius);
            font-weight: 500;
            text-decoration: none;
            transition: all 0.2s ease;
            border: none;
            cursor: pointer;
            font-size: 0.85rem;
        }

        .btn-primary {
            background: var(--secondary);
            color: var(--white);
        }

        .btn-primary:hover {
            background: var(--primary-text-emphasis);
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(var(--tblr-primary-rgb), 0.3);
        }

        .btn-outline {
            background: transparent;
            border: 1px solid var(--secondary);
            color: var(--secondary);
        }

        .btn-outline:hover {
            background: var(--secondary);
            color: var(--white);
            transform: translateY(-1px);
        }

        /* Empty State */
        .empty-state {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
            text-align: center;
        }

        .empty-state i {
            font-size: 2.5rem;
            color: var(--secondary);
            margin-bottom: 0.8rem;
            opacity: 0.5;
        }

        .empty-state h3 {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--body-color);
            margin-bottom: 0.4rem;
        }

        .empty-state p {
            color: var(--secondary);
            margin-bottom: 1rem;
            max-width: 300px;
            font-size: 0.85rem;
        }

        /* Modal Styles */
        .modal-content {
            background: var(--white);
            border: 1px solid var(--secondary);
            border-radius: var(--border-radius);
            box-shadow: var(--tblr-box-shadow-lg);
        }

        .modal-header {
            padding: 0.75rem;
            border-bottom: 1px solid var(--secondary);
            background: var(--light);
        }

        .modal-title {
            font-size: 1rem;
            font-weight: 600;
            color: var(--body-color);
        }

        .modal-body {
            padding: 0.75rem;
        }

        .modal-footer {
            padding: 0.75rem;
            border-top: 1px solid var(--secondary);
            background: var(--light);
        }

        /* Form Styles */
        .form-group {
            margin-bottom: 0.75rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.3rem;
            font-weight: 500;
            color: var(--body-color);
            font-size: 0.85rem;
        }

        .form-control {
            width: 100%;
            padding: 0.4rem 0.8rem;
            border: 1px solid var(--secondary);
            border-radius: var(--border-radius);
            background: var(--white);
            color: var(--body-color);
            transition: all 0.3s ease;
            font-size: 0.85rem;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 2px var(--primary-bg-subtle);
        }

        /* Dropdown Styles */
        .dropdown {
            position: relative;
            display: inline-block;
        }

        .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            z-index: 1000;
            display: none;
            min-width: 10rem;
            padding: 0.4rem 0;
            margin: 0.1rem 0 0;
            font-size: 0.8rem;
            color: var(--body-color);
            text-align: left;
            list-style: none;
            background-color: var(--white);
            background-clip: padding-box;
            border: 1px solid var(--secondary);
            border-radius: var(--border-radius);
            box-shadow: var(--tblr-box-shadow-lg);
        }

        .dropdown-menu.show {
            display: block;
        }

        .dropdown-item {
            display: block;
            width: 100%;
            padding: 0.4rem 0.8rem;
            clear: both;
            font-weight: 400;
            color: var(--body-color);
            text-align: inherit;
            text-decoration: none;
            white-space: nowrap;
            background-color: transparent;
            border: 0;
            transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out;
        }

        .dropdown-item:hover {
            color: var(--primary);
            background-color: var(--primary-bg-subtle);
        }

        .dropdown-divider {
            height: 0;
            margin: 0.4rem 0;
            overflow: hidden;
            border-top: 1px solid var(--secondary);
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .content-area {
                flex-direction: column;
                height: auto;
            }
            
            .sidebar {
                flex: 0 0 auto;
                height: 250px;
            }
        }

        @media (max-width: 768px) {
            .dashboard-header {
                padding: 0.75rem;
            }
            
            .dashboard-header h1 {
                font-size: 1.3rem;
            }
            
            .action-cards {
                grid-template-columns: 1fr;
            }
            
            .detail-item {
                flex-direction: column;
                gap: 0.2rem;
            }
            
            .detail-label {
                flex: 0 0 auto;
            }
            
            .action-buttons {
                flex-direction: column;
            }
        }

        /* Dark Mode Specific Styles */
        [data-bs-theme="dark"] .action-card,
        [data-bs-theme="dark"] .sidebar,
        [data-bs-theme="dark"] .main-content,
        [data-bs-theme="dark"] .detail-card,
        [data-bs-theme="dark"] .modal-content {
            background: var(--tblr-dark);
            border-color: var(--secondary);
        }

        [data-bs-theme="dark"] .sidebar-header,
        [data-bs-theme="dark"] .content-header,
        [data-bs-theme="dark"] .modal-header,
        [data-bs-theme="dark"] .modal-footer {
            background: var(--tblr-tertiary-bg);
            border-color: var(--secondary);
        }

        [data-bs-theme="dark"] .meeting-item {
            background: var(--tblr-dark);
            border-color: var(--secondary);
        }

        [data-bs-theme="dark"] .form-control,
        [data-bs-theme="dark"] .search-box input {
            background: var(--tblr-tertiary-bg);
            border-color: var(--secondary);
            color: var(--tblr-body-color);
        }

        [data-bs-theme="dark"] .empty-state i {
            color: var(--secondary);
        }
        
        p.text-secondary.m-0 {
            display: none;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('include.user.toast', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <div class="page jm-dashboard">
        <?php echo $__env->make('include.user.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <div class="page-wrapper">
            <div class="container-xl">
                <div class="dashboard-layout">
                    <!-- Dashboard Header -->
                    <div class="dashboard-header">
                        <h1><?php echo e(__('Meeting Dashboard')); ?></h1>
                        <p><?php echo e(__('Manage your meetings, schedule new ones, and join existing conferences')); ?></p>
                    </div>

                    <!-- Action Cards -->
                    <div class="action-cards">
                        <div class="action-card">
                            <div class="action-card-icon create">
                                <i class="fas fa-plus"></i>
                            </div>
                            <h3><?php echo e(__('Create Meeting')); ?></h3>
                            <p><?php echo e(__('Schedule a new meeting for future dates')); ?></p>
                            <a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createMeetingModal">
                                <i class="fas fa-plus me-2"></i><?php echo e(__('Create Now')); ?>

                            </a>
                        </div>

                        <div class="action-card">
                            <div class="action-card-icon join">
                                <i class="fas fa-sign-in-alt"></i>
                            </div>
                            <h3><?php echo e(__('Join Meeting')); ?></h3>
                            <p><?php echo e(__('Enter meeting ID to join an existing conference')); ?></p>
                            <form id="meetingDashboard" class="d-flex gap-2">
                                <input type="text" class="form-control" maxlength="9" id="conferenceId" name="id" placeholder="<?php echo e(__('Meeting ID')); ?>" required>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-arrow-right"></i>
                                </button>
                            </form>
                        </div>

                        <div class="action-card">
                            <div class="action-card-icon start">
                                <i class="fas fa-video"></i>
                            </div>
                            <h3><?php echo e(__('Start Instant Meeting')); ?></h3>
                            <p><?php echo e(__('Launch an instant meeting right now')); ?></p>
                            <a onclick="location.href='<?php echo e(route('meeting', ['id' => getAuthUserInfo('username')])); ?>'" class="btn btn-primary">
                                <i class="fas fa-play me-2"></i><?php echo e(__('Start Now')); ?>

                            </a>
                        </div>

                        <div class="action-card">
                            <div class="action-card-icon copy">
                                <i class="fas fa-copy"></i>
                            </div>
                            <h3><?php echo e(__('Copy the instant meeting')); ?></h3>
                            <p><?php echo e(__('Share your personal meeting link')); ?></p>
                            <a id="copyMeetingLink" class="btn btn-primary" data-link="<?php echo e(route('meeting', ['id' => getAuthUserInfo('username')])); ?>">
                                <i class="fas fa-copy me-2"></i><?php echo e(__('Copy Link')); ?>

                            </a>
                        </div>
                    </div>

                    <!-- Main Content Area -->
                    <div class="content-area">
                        <!-- Sidebar -->
                        <div class="sidebar meetingDetail" <?php if(!$firstMeeting): ?> hidden <?php endif; ?>>
                            <div class="sidebar-header">
                                <h2><?php echo e(__('Your Meetings')); ?></h2>
                                <div class="search-box">
                                    <i class="fas fa-search"></i>
                                    <form id="searchMeeting" action="<?php echo e(route('dashboard')); ?>" class="d-flex w-100 m-0">
                                        <input type="text" name="search" class="form-control" placeholder="<?php echo e(__('Search meetings...')); ?>" value="<?php echo e($search); ?>" />
                                    </form>
                                </div>
                            </div>
                            <div class="meeting-list">
                                <?php $__currentLoopData = $meetings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meeting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="meeting-item"
                                        data-title="<?php echo e($meeting->title); ?>"
                                        data-description="<?php echo e($meeting->description); ?>"
                                        data-id="<?php echo e($meeting->id); ?>"
                                        data-auto="<?php echo e($meeting->meeting_id); ?>"
                                        data-password="<?php echo e($meeting->password); ?>"
                                        data-date="<?php echo e($meeting->date ? \Carbon\Carbon::parse($meeting->date)->format('Y-m-d') : ''); ?>"
                                        data-time="<?php echo e($meeting->time ? \Carbon\Carbon::parse($meeting->time)->format('H:i') : ''); ?>"
                                        data-timezone="<?php echo e($meeting->timezone); ?>">
                                        <div class="meeting-title">
                                            <?php echo e($meeting->title); ?>

                                            <span class="meeting-badge"><?php echo e(__('Meeting')); ?></span>
                                        </div>
                                        <div class="meeting-description"><?php echo e($meeting->description); ?></div>
                                        <div class="meeting-meta">
                                            <div class="meeting-id">
                                                <i class="fas fa-id-badge"></i>
                                                <?php echo e($meeting->meeting_id); ?>

                                            </div>
                                            <div class="meeting-time">
                                                <i class="far fa-clock"></i>
                                                <?php echo e($meeting->created_at->diffForHumans()); ?>

                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="mt-3">
                                    <?php echo e($meetings->links('pagination::bootstrap-5')); ?>

                                </div>
                            </div>
                        </div>

                        <!-- Main Content -->
                        <div class="main-content meetingDetail" <?php if(!$firstMeeting): ?> hidden <?php endif; ?>>
                            <div class="content-header">
                                <h2 id="meetingTitleDetail"><?php echo e($firstMeeting ? $firstMeeting->title : ''); ?></h2>
                                <div class="dropdown">
                                    <button class="btn btn-outline dropdown-toggle" type="button" id="meetingActionsDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fas fa-ellipsis-v me-2"></i><?php echo e(__('Actions')); ?>

                                    </button>
                                    <ul class="dropdown-menu" aria-labelledby="meetingActionsDropdown">
                                        <li><a id="copyParticularMeeting" class="dropdown-item"><i class="far fa-copy me-2"></i><?php echo e(__('Copy Link')); ?></a></li>
                                        <li><a href="#" class="dropdown-item" data-bs-toggle="modal" data-bs-target="#embed"><i class="fas fa-code me-2"></i><?php echo e(__('Embed')); ?></a></li>
                                        <li><a href="#" class="dropdown-item" data-bs-toggle="modal" data-bs-target="#Invite"><i class="fas fa-user-plus me-2"></i><?php echo e(__('Invite')); ?></a></li>
                                        <li><a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#editMeetingModal"><i class="far fa-edit me-2"></i><?php echo e(__('Edit')); ?></a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><a class="dropdown-item text-danger delete" data-id="<?php echo e($firstMeeting ? $firstMeeting->id : ''); ?>" data-action="<?php echo e(route('deleteMeeting')); ?>"><i class="far fa-trash-alt me-2"></i><?php echo e(__('Delete')); ?></a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="content-body">
                                <div class="meeting-details">
                                    <div class="detail-card">
                                        <h3><i class="fas fa-info-circle me-2"></i><?php echo e(__('Meeting Information')); ?></h3>
                                        <div class="detail-item">
                                            <div class="detail-label"><?php echo e(__('Meeting ID')); ?></div>
                                            <div class="detail-value" id="meetingIdDetail"><?php echo e($firstMeeting ? $firstMeeting->meeting_id : ''); ?></div>
                                        </div>
                                        <div class="detail-item">
                                            <div class="detail-label"><?php echo e(__('Password')); ?></div>
                                            <div class="detail-value" id="meetingPasswordDetail"><?php echo e($firstMeeting && $firstMeeting->password ? $firstMeeting->password : '-'); ?></div>
                                        </div>
                                        <div class="detail-item">
                                            <div class="detail-label"><?php echo e(__('Date')); ?></div>
                                            <div class="detail-value" id="meetingDateDetail"><?php echo e($firstMeeting && $firstMeeting->date ? formatDate($firstMeeting->date) : '-'); ?></div>
                                        </div>
                                        <div class="detail-item">
                                            <div class="detail-label"><?php echo e(__('Time')); ?></div>
                                            <div class="detail-value" id="meetingTimeDetail"><?php echo e($firstMeeting && $firstMeeting->time ? formatTime($firstMeeting->time) : '-'); ?></div>
                                        </div>
                                        <div class="detail-item">
                                            <div class="detail-label"><?php echo e(__('Timezone')); ?></div>
                                            <div class="detail-value" id="meetingTimezoneDetail"><?php echo e($firstMeeting && $firstMeeting->timezone ? $firstMeeting->timezone : '-'); ?></div>
                                        </div>
                                        <div class="detail-item">
                                            <div class="detail-label"><?php echo e(__('Description')); ?></div>
                                            <div class="detail-value" id="meetingDescriptionDetail"><?php echo e($firstMeeting && $firstMeeting->description ? $firstMeeting->description : '-'); ?></div>
                                        </div>
                                    </div>

                                    <div class="detail-card">
                                        <h3><i class="fas fa-calendar-plus me-2"></i><?php echo e(__('Add to Calendar')); ?></h3>
                                        <div class="addto-btn">
                                            <?php if($firstMeeting && $firstMeeting->date && $firstMeeting->time): ?>
                                                <?php
                                                    // Parse date and time
                                                    $dateObj = \Carbon\Carbon::parse($firstMeeting->date);
                                                    $timeObj = \Carbon\Carbon::parse($firstMeeting->time);
                                                    
                                                    // Create start and end DateTime objects
                                                    $startDateTime = \Carbon\Carbon::create(
                                                        $dateObj->year, 
                                                        $dateObj->month, 
                                                        $dateObj->day, 
                                                        $timeObj->hour, 
                                                        $timeObj->minute
                                                    );
                                                    
                                                    $endDateTime = $startDateTime->copy()->addHour(); // 1 hour meeting
                                                    
                                                    // Format for Google Calendar
                                                    $googleStart = $startDateTime->format('Ymd\THis\Z');
                                                    $googleEnd = $endDateTime->format('Ymd\THis\Z');
                                                    
                                                    // Format for Outlook
                                                    $outlookStart = $startDateTime->toIso8601String();
                                                    $outlookEnd = $endDateTime->toIso8601String();
                                                    
                                                    // Build URLs
                                                    $googleUrl = "https://calendar.google.com/calendar/render?action=TEMPLATE&text=" . urlencode($firstMeeting->title) . 
                                                        "&details=" . urlencode($firstMeeting->description . "\n\nMeeting ID: " . $firstMeeting->meeting_id) . 
                                                        "&dates=" . $googleStart . "/" . $googleEnd;
                                                        
                                                    $outlookUrl = "https://outlook.live.com/calendar/0/deeplink/compose?subject=" . urlencode($firstMeeting->title) . 
                                                        "&body=" . urlencode($firstMeeting->description . "\n\nMeeting ID: " . $firstMeeting->meeting_id) . 
                                                        "&startdt=" . urlencode($outlookStart) . "&enddt=" . urlencode($outlookEnd);
                                                ?>
                                                <a href="<?php echo e($googleUrl); ?>" target="_blank" class="btn btn-outline">
                                                    <i class="fab fa-google me-2"></i><?php echo e(__('Google Calendar')); ?>

                                                </a>
                                                <a href="<?php echo e($outlookUrl); ?>" target="_blank" class="btn btn-outline">
                                                    <i class="fab fa-microsoft me-2"></i><?php echo e(__('Microsoft Outlook')); ?>

                                                </a>
                                            <?php else: ?>
                                                <a href="#" class="btn btn-outline disabled" onclick="alert('<?php echo e(__("Please set a valid date and time for this meeting before adding to calendar.")); ?>'); return false;">
                                                    <i class="fab fa-google me-2"></i><?php echo e(__('Google Calendar')); ?>

                                                </a>
                                                <a href="#" class="btn btn-outline disabled" onclick="alert('<?php echo e(__("Please set a valid date and time for this meeting before adding to calendar.")); ?>'); return false;">
                                                    <i class="fab fa-microsoft me-2"></i><?php echo e(__('Microsoft Outlook')); ?>

                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="action-buttons">
                                    <a href="<?php echo e($firstMeeting ? route('meeting', ['id' => $firstMeeting->meeting_id]) : '#'); ?>" class="btn btn-primary" id="meetingStart">
                                        <i class="fas fa-video me-2"></i><?php echo e(__('Start Meeting')); ?>

                                    </a>
                                    <a href="#" class="btn btn-outline" data-bs-toggle="modal" data-bs-target="#Invite">
                                        <i class="fas fa-share-alt me-2"></i><?php echo e(__('Share Meeting')); ?>

                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Empty State -->
                        <div class="main-content" <?php if($firstMeeting): ?> hidden <?php endif; ?>>
                            <div class="empty-state">
                                <i class="fas fa-calendar-times"></i>
                                <h3><?php echo e(__('No meetings found')); ?></h3>
                                <p><?php echo e(__("Try adjusting your search or create a new meeting to get started.")); ?></p>
                                <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-primary">
                                    <i class="fas fa-redo me-2"></i><?php echo e(__('Reset View')); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Meeting template for dynamic content -->
    <div id="meetingTemplate" style="display: none;">
        <div class="meeting-item" data-title="" data-description="" data-id="" data-auto="" data-password="" data-date="" data-time="" data-timezone="">
            <div class="meeting-title">
                <span></span>
                <span class="meeting-badge"><?php echo e(__('Meeting')); ?></span>
            </div>
            <div class="meeting-description"></div>
            <div class="meeting-meta">
                <div class="meeting-id">
                    <i class="fas fa-id-badge"></i>
                    <span></span>
                </div>
                <div class="meeting-time">
                    <i class="far fa-clock"></i>
                    <?php echo e(__('Just Now')); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Create meeting modal -->
    <div class="modal modal-blur fade" id="createMeetingModal" tabindex="1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <form id="createMeetingsForm" data-action="<?php echo e(route('createMeeting')); ?>" class="mb-0">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('Create Meeting')); ?> | ID: <span id="createMeetingId"></span></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="form-label"><?php echo e(__('Title')); ?>*</label>
                            <input id="title" name="title" type="text" class="form-control" placeholder="<?php echo e(__('Enter meeting title')); ?>" minlength="3" maxlength="100" required autofocus>
                        </div>
                        <div class="form-group">
                            <label class="form-label"><?php echo e(__('Description')); ?></label>
                            <textarea id="description" name="description" class="form-control" rows="4" placeholder="<?php echo e(__('Enter meeting description')); ?>"></textarea>
                        </div>
                        <div class="form-group d-none">
                            <label class="form-label"><?php echo e(__('Password')); ?></label>
                            <input id="password" name="password" type="text" class="form-control" placeholder="<?php echo e(__('Enter meeting password')); ?>" minlength="4" maxlength="8">
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Date')); ?></label>
                                    <input id="date" name="date" type="date" class="form-control">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Time')); ?></label>
                                    <input id="time" name="time" type="time" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="form-group d-none">
                            <label class="form-label"><?php echo e(__('Time Zone')); ?></label>
                            <select id="timezone" name="timezone" class="form-control">
                                <option value=""><?php echo e(__('Select meeting timezone')); ?></option>
                                <?php $__currentLoopData = $timezones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($timezone['value']); ?>"><?php echo e($timezone['value']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>>
                            </select>
                        </div>
                        <input type="hidden" id="createMeetingsFormId" name="meeting_id" />
                    </div>
                    <div class="modal-footer">
                        <a href="" class="btn btn-outline" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></a>
                        <button id="createMeetingButton" class="btn btn-primary"><?php echo e(__('Create Meeting')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit meeting modal -->
    <div class="modal modal-blur fade" id="editMeetingModal" tabindex="1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <form id="editMeetingsForm" data-action="<?php echo e(route('editMeeting')); ?>" class="mb-0">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('Edit Meeting')); ?> | ID: <span id="meetingIdEdit"></span></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="form-label"><?php echo e(__('Title')); ?>*</label>
                            <input id="titleEdit" name="title" type="text" class="form-control" placeholder="<?php echo e(__('Enter meeting title')); ?>" minlength="3" maxlength="100" required autofocus>
                        </div>
                        <div class="form-group">
                            <label class="form-label"><?php echo e(__('Description')); ?></label>
                            <textarea id="descriptionEdit" name="description" class="form-control" rows="4" placeholder="<?php echo e(__('Enter meeting description')); ?>"></textarea>
                        </div>
                        <div class="form-group">
                            <label class="form-label"><?php echo e(__('Password')); ?></label>
                            <input id="passwordEdit" name="password" type="text" class="form-control" placeholder="<?php echo e(__('Enter meeting password')); ?>" minlength="4" maxlength="8">
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Date')); ?></label>
                                    <input id="dateEdit" name="date" type="date" class="form-control">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Time')); ?></label>
                                    <input id="timeEdit" name="time" type="time" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label"><?php echo e(__('Time Zone')); ?></label>
                            <select id="timezoneEdit" name="timezone" class="form-control">
                                <option value=""><?php echo e(__('Select meeting timezone')); ?></option>
                                <?php $__currentLoopData = $timezones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($timezone['value']); ?>"><?php echo e($timezone['value']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>>
                            </select>
                        </div>
                        <input type="hidden" id="meetingsFormIdEdit" name="id" />
                    </div>
                    <div class="modal-footer">
                        <a href="" class="btn btn-outline" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></a>
                        <button id="updateMeetingButton" class="btn btn-primary"><?php echo e(__('Update Meeting')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Invite modal -->
    <div class="modal modal-blur fade" id="Invite" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Invite People')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="inviteForm" class="mb-0">
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="form-label"><?php echo e(__('Email Addresses')); ?></label>
                            <select id="inviteEmail" name="emails[]" multiple>
                                <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($contact->email); ?>"><?php echo e($contact->email); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <a class="btn btn-outline" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></a>
                        <button class="btn btn-primary" data-bs-dismiss="modal" type="submit"><?php echo e(__('Send Invites')); ?></button>
                        <input type="hidden" id="inviteId" name="id" />
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Embed modal -->
    <div class="modal modal-blur fade" id="embed" tabindex="1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Embed Meeting')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="form-label"><?php echo e(__('Embed Code')); ?></label>
                        <textarea class="form-control" rows="5" id="embedTextarea" readonly></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="#" class="btn btn-outline" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></a>
                    <a class="btn btn-primary" id="copyEmbedCode"><?php echo e(__('Copy Code')); ?></a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        let meetingId;
        let meetingExist = "<?php echo e(!$meetings->isEmpty()); ?>" || null;
        let timeLimit = "<?php echo e($timeLimit); ?>";
        const meetingBaseUrl = "<?php echo e(url('/meeting')); ?>";
        
        if (meetingExist) {
            $('.meeting-item:first').addClass('active');
            meetingId = "<?php echo e($firstMeeting ? $firstMeeting->id : ''); ?>";
        }

        // Meeting item click handler
        $(document).on('click', '.meeting-item', function() {
            // Remove active class from all meeting items
            $('.meeting-item').removeClass('active');
            
            // Add active class to clicked item
            $(this).addClass('active');
            
            // Get meeting data
            const title = $(this).data('title');
            const description = $(this).data('description');
            const id = $(this).data('id');
            const auto = $(this).data('auto');
            const password = $(this).data('password');
            const date = $(this).data('date');
            const time = $(this).data('time');
            const timezone = $(this).data('timezone');
            
            // Update meeting details
            $('#meetingTitleDetail').text(title);
            $('#meetingIdDetail').text(auto);
            $('#meetingPasswordDetail').text(password || '-');
            $('#meetingDateDetail').text(date || '-');
            $('#meetingTimeDetail').text(time || '-');
            $('#meetingTimezoneDetail').text(timezone || '-');
            $('#meetingDescriptionDetail').text(description || '-');
            
            // Update start meeting link
            $('#meetingStart').attr('href', meetingBaseUrl + '/' + auto);
            
            // Update delete button data-id
            $('.delete').data('id', id);
            
            // Update edit modal data
            $('#meetingsFormIdEdit').val(id);
            $('#meetingIdEdit').text(auto);
            $('#titleEdit').val(title);
            $('#descriptionEdit').val(description);
            $('#passwordEdit').val(password);
            $('#dateEdit').val(date);
            $('#timeEdit').val(time);
            $('#timezoneEdit').val(timezone);
            
            // Update invite modal data
            $('#inviteId').val(id);
            
            // Update copy particular meeting link
            $('#copyParticularMeeting').data('link', meetingBaseUrl + '/' + auto);
            
            // Update embed code
            const embedCode = `<iframe src="${meetingBaseUrl}/${auto}" width="100%" height="500" frameborder="0" allowfullscreen></iframe>`;
            $('#embedTextarea').val(embedCode);
            
            // Update global meetingId variable
            meetingId = id;
            
            // Update calendar links if date and time are available
            if (date && time) {
                // Parse date and time
                const [year, month, day] = date.split('-');
                const [hours, minutes] = time.split(':');
                
                // Create Date objects
                const startDate = new Date(year, month - 1, day, hours, minutes);
                const endDate = new Date(startDate.getTime() + 60 * 60 * 1000); // 1 hour meeting
                
                // Format dates for Google Calendar URL
                const formatGoogleDate = (date) => {
                    return date.toISOString().replace(/[-:]/g, '').split('.')[0] + 'Z';
                };
                
                // Format dates for Outlook URL
                const formatOutlookDate = (date) => {
                    return date.toISOString();
                };
                
                // Build Google Calendar URL
                const googleUrl = `https://calendar.google.com/calendar/render?action=TEMPLATE&text=${encodeURIComponent(title)}&details=${encodeURIComponent(description + '\n\nMeeting ID: ' + auto)}&dates=${formatGoogleDate(startDate)}/${formatGoogleDate(endDate)}`;
                
                // Build Outlook Calendar URL
                const outlookUrl = `https://outlook.live.com/calendar/0/deeplink/compose?subject=${encodeURIComponent(title)}&body=${encodeURIComponent(description + '\n\nMeeting ID: ' + auto)}&startdt=${encodeURIComponent(formatOutlookDate(startDate))}&enddt=${encodeURIComponent(formatOutlookDate(endDate))}`;
                
                // Update calendar links
                $('#addToGoogle').attr('href', googleUrl).removeClass('disabled');
                $('#addToOutlook').attr('href', outlookUrl).removeClass('disabled');
            } else {
                // Disable calendar links if no date or time
                $('#addToGoogle').attr('href', '#').addClass('disabled').off('click').on('click', function(e) {
                    e.preventDefault();
                    alert('Please make sure the meeting has a valid date and time before adding to Google Calendar.');
                });
                
                $('#addToOutlook').attr('href', '#').addClass('disabled').off('click').on('click', function(e) {
                    e.preventDefault();
                    alert('Please make sure the meeting has a valid date and time before adding to Outlook Calendar.');
                });
            }
        });

        // Copy meeting link functionality
        $('#copyMeetingLink').on('click', function(e) {
            e.preventDefault();
            const link = $(this).data('link');
            navigator.clipboard.writeText(link).then(function() {
                // Show success message
                const toast = new bootstrap.Toast(document.getElementById('toast-simple'));
                toast.show();
            });
        });

        // Copy particular meeting link
        $(document).on('click', '#copyParticularMeeting', function(e) {
            e.preventDefault();
            const link = $(this).data('link');
            navigator.clipboard.writeText(link).then(function() {
                // Show success message
                const toast = new bootstrap.Toast(document.getElementById('toast-simple'));
                toast.show();
            });
        });

        // Copy embed code
        $('#copyEmbedCode').on('click', function(e) {
            e.preventDefault();
            const embedCode = $('#embedTextarea').val();
            navigator.clipboard.writeText(embedCode).then(function() {
                // Show success message
                const toast = new bootstrap.Toast(document.getElementById('toast-simple'));
                toast.show();
            });
        });

        // Delete meeting confirmation
        $(document).on('click', '.delete', function(e) {
            e.preventDefault();
            const id = $(this).data('id');
            const action = $(this).data('action');
            
            if (confirm('<?php echo e(__("Are you sure you want to delete this meeting?")); ?>')) {
                $.post(action, { id: id, _token: '<?php echo e(csrf_token()); ?>' }, function(response) {
                    if (response.success) {
                        location.reload();
                    } else {
                        alert('<?php echo e(__("Failed to delete meeting. Please try again.")); ?>');
                    }
                });
            }
        });
    </script>
    <script src="<?php echo e(asset('/js/tom-select.complete.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dashboard.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/skweela_net/resources/views/dashboard.blade.php ENDPATH**/ ?>