@extends('admin.payment-gateway.index')

@section('payment-gateway-content')
    <form class="col-12 col-md-9 d-flex flex-column" action="{{ route('admin.payment_gateways.update-paystack') }}"
        method="post">
        @csrf
        <div class="card-body">
            <div class="tab-content" id="pills-tabContent">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-paystack">{{ __('Enabled') }}</label>
                            <select name="PAYSTACK" id="i-paystack"
                                class="form-select @error('PAYSTACK') is-invalid @enderror">
                                @foreach ([1 => __('Yes'), 0 => __('No')] as $key => $value)
                                    <option value="{{ $key }}" @if (
                                        (old('PAYSTACK') !== null && old('PAYSTACK') == $key) ||
                                            (getSetting('PAYSTACK') == $key && old('PAYSTACK') == null)) selected @endif>
                                        {{ $value }}
                                    </option>
                                @endforeach
                            </select>
                            @error('PAYSTACK')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-paystack-secret-key">{{ __('Secret') }}</label>
                            <input type="password" name="PAYSTACK_SECRET_KEY" id="i-paystack-secret-key"
                                class="form-control @error('PAYSTACK_SECRET_KEY') is-invalid @enderror"
                                value="{{ old('PAYSTACK_SECRET_KEY') ?? getSetting('PAYSTACK_SECRET_KEY') }}"
                                placeholder="{{ __('Secret') }}">
                            @error('PAYSTACK_SECRET_KEY')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-paystack-wh-url">{{ __('Webhook URL') }}</label>
                            <div class="input-group">
                                <input type="text" dir="ltr" name="paystack_wh_url" id="i-paystack-wh-url"
                                    class="form-control" value="{{ route('webhooks.paystack') }}" readonly>
                                <button class="btn btn-secondary" type="button" id="webhookUrlPaystackCopy">
                                    {{ __('Copy') }}
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-callback-wh-url">{{ __('Callback URL') }}</label>
                            <div class="input-group">
                                <input type="text" dir="ltr" name="paystack_cb_url" id="i-paystack-cb-url"
                                    class="form-control" value="{{ route('callback.paystack') }}" readonly>
                                <button class="btn btn-secondary" type="button" id="callbackUrlPaystackCopy">
                                    {{ __('Copy') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-footer bg-transparent">
            <div class="btn-list justify-content-end">
                <button type="submit" name="submit" class="btn btn-primary mt-3">{{ __('Save') }}</button>
            </div>
        </div>
    </form>
@endsection
