import { EnhancedEventEmitter } from './enhancedEvents';
import type { Consumer, ConsumerType, ConsumerScore, ConsumerLayers, ConsumerDump, ConsumerStat, ConsumerTraceEventType, ConsumerTraceEventData, ConsumerEvents, ConsumerObserver } from './ConsumerTypes';
import { Channel } from './Channel';
import type { TransportInternal } from './Transport';
import type { ProducerStat } from './ProducerTypes';
import type { MediaKind, RtpParameters } from './rtpParametersTypes';
import type { AppData } from './types';
import * as FbsConsumer from './fbs/consumer';
type ConsumerInternal = TransportInternal & {
    consumerId: string;
};
type ConsumerData = {
    producerId: string;
    kind: MediaKind;
    rtpParameters: RtpParameters;
    type: ConsumerType;
};
export declare class ConsumerImpl<ConsumerAppData extends AppData = AppData> extends EnhancedEventEmitter<ConsumerEvents> implements Consumer {
    #private;
    constructor({ internal, data, channel, appData, paused, producerPaused, score, preferredLayers, }: {
        internal: ConsumerInternal;
        data: ConsumerData;
        channel: Channel;
        appData?: ConsumerAppData;
        paused: boolean;
        producerPaused: boolean;
        score?: ConsumerScore;
        preferredLayers?: ConsumerLayers;
    });
    get id(): string;
    get producerId(): string;
    get closed(): boolean;
    get kind(): MediaKind;
    get rtpParameters(): RtpParameters;
    get type(): ConsumerType;
    get paused(): boolean;
    get producerPaused(): boolean;
    get priority(): number;
    get score(): ConsumerScore;
    get preferredLayers(): ConsumerLayers | undefined;
    get currentLayers(): ConsumerLayers | undefined;
    get appData(): ConsumerAppData;
    set appData(appData: ConsumerAppData);
    get observer(): ConsumerObserver;
    /**
     * Just for testing purposes.
     *
     * @private
     */
    get channelForTesting(): Channel;
    close(): void;
    transportClosed(): void;
    dump(): Promise<ConsumerDump>;
    getStats(): Promise<(ConsumerStat | ProducerStat)[]>;
    pause(): Promise<void>;
    resume(): Promise<void>;
    setPreferredLayers({ spatialLayer, temporalLayer, }: ConsumerLayers): Promise<void>;
    setPriority(priority: number): Promise<void>;
    unsetPriority(): Promise<void>;
    requestKeyFrame(): Promise<void>;
    enableTraceEvent(types?: ConsumerTraceEventType[]): Promise<void>;
    private handleWorkerNotifications;
    private handleListenerError;
}
export declare function parseTraceEventData(trace: FbsConsumer.TraceNotification): ConsumerTraceEventData;
export {};
//# sourceMappingURL=Consumer.d.ts.map