import { EnhancedEventEmitter } from './enhancedEvents';
import type { Worker, WorkerSettings, WorkerUpdateableSettings, WorkerResourceUsage, WorkerDump, WorkerEvents, WorkerObserver } from './WorkerTypes';
import type { WebRtcServer, WebRtcServerOptions } from './WebRtcServerTypes';
import type { Router, RouterOptions } from './RouterTypes';
import type { AppData } from './types';
import * as FbsWorker from './fbs/worker';
export declare const workerBin: string;
export declare class WorkerImpl<WorkerAppData extends AppData = AppData> extends EnhancedEventEmitter<WorkerEvents> implements Worker {
    #private;
    constructor({ logLevel, logTags, rtcMinPort, rtcMaxPort, dtlsCertificateFile, dtlsPrivateKeyFile, libwebrtcFieldTrials, disableLiburing, appData, }: WorkerSettings<WorkerAppData>);
    get pid(): number;
    get closed(): boolean;
    get died(): boolean;
    get subprocessClosed(): boolean;
    get appData(): WorkerAppData;
    set appData(appData: WorkerAppData);
    get observer(): WorkerObserver;
    /**
     * Just for testing purposes.
     */
    get webRtcServersForTesting(): Set<WebRtcServer>;
    /**
     * Just for testing purposes.
     */
    get routersForTesting(): Set<Router>;
    close(): void;
    dump(): Promise<WorkerDump>;
    getResourceUsage(): Promise<WorkerResourceUsage>;
    updateSettings({ logLevel, logTags, }?: WorkerUpdateableSettings<WorkerAppData>): Promise<void>;
    createWebRtcServer<WebRtcServerAppData extends AppData = AppData>({ listenInfos, appData, }: WebRtcServerOptions<WebRtcServerAppData>): Promise<WebRtcServer<WebRtcServerAppData>>;
    createRouter<RouterAppData extends AppData = AppData>({ mediaCodecs, appData, }?: RouterOptions<RouterAppData>): Promise<Router<RouterAppData>>;
    private workerDied;
    private handleListenerError;
}
export declare function parseWorkerDumpResponse(binary: FbsWorker.DumpResponse): WorkerDump;
//# sourceMappingURL=Worker.d.ts.map