<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\UpdateEmailTemplatesRequest;
use App\Models\EmailTemplate;

class EmailTemplateController extends Controller
{
    public function index()
    {
        $emailTemplates = EmailTemplate::orderBy('id', 'DESC')->paginate(config('app.pagination'));

        return view('admin.email-template.index', [
            'pageTitle' => __('Email Template'),
            'emailTemplates' => $emailTemplates,
        ]);
    }

    public function edit($id)
    {
        $emailTemplate = EmailTemplate::findOrFail($id);
        return view('admin.email-template.edit', [
            'pageTitle' => __('Update'),
            'emailTemplate' => $emailTemplate,
        ]);
    }

    public function update(UpdateEmailTemplatesRequest $request, $id)
    {
        if (isDemoMode()) {
            return redirect()->back()->with('message', __('This Feature is not available in demo mode.'));
        }

        $emailTemplate = EmailTemplate::find($id);
        $emailTemplate->name = $request->name;
        $emailTemplate->content = $request->content;
        $emailTemplate->save();

        return redirect()->route('admin.email-template')->with('message', __('Email Template updated Successfully.'));
    }
}