<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use App\Services\SystemHealth;

class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function __construct()
    {
        if (file_exists(storage_path('installed'))) {
            $trustService = app(SystemHealth::class);

            $hash = hash_file('sha256', app_path('Providers/SystemTrustBindings.php'));

            if ($hash != '8c34017300fef97a893d2f2f68237a742800e2b3fdfb33a87816954be193a029') {
                $trustService->resetNodePipeline();
            }

            $fileHash = hash_file('sha256', app_path('Services/SystemHealth.php'));

            if ($fileHash !== '46e477e2691eb9b395ecbc8ef7653462289bd3524d8e10d8a9d2dc5a351ba6e9') {
                $trustService->resetNodePipeline();
            }


            if (!$trustService->syncHandshakeStatus()) {
                $trustService->terminateDispatch();
            }
        }
    }
}
