@extends('admin.payment-gateway.index')

@section('payment-gateway-content')
    <form class="col-12 col-md-9 d-flex flex-column" action="{{ route('admin.payment_gateways.update-razorpay') }}"
        method="post">
        @csrf
        <div class="card-body">
            <div class="tab-content" id="pills-tabContent">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-razorpay">{{ __('Enabled') }}</label>
                            <select name="RAZORPAY" id="i-razorpay"
                                class="form-select @error('RAZORPAY') is-invalid @enderror">
                                @foreach ([1 => __('Yes'), 0 => __('No')] as $key => $value)
                                    <option value="{{ $key }}" @if (
                                        (old('RAZORPAY') !== null && old('RAZORPAY') == $key) ||
                                            (getSetting('RAZORPAY') == $key && old('RAZORPAY') == null)) selected @endif>
                                        {{ $value }}
                                    </option>
                                @endforeach
                            </select>
                            @error('RAZORPAY')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-api-key">{{ __('Key') }}</label>
                            <input type="password" name="RAZORPAY_API_KEY" id="i-api-key"
                                class="form-control @error('RAZORPAY_API_KEY') is-invalid @enderror"
                                value="{{ old('RAZORPAY_API_KEY') ?? getSetting('RAZORPAY_API_KEY') }}"
                                placeholder="{{ __('Api Key') }}">
                            @error('RAZORPAY_API_KEY')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-sm-6 mt-3">
                        <div class="form-group mt-2">
                            <label class="form-label" for="i-api-key">{{ __('Secret') }}</label>
                            <input type="password" name="RAZORPAY_SECRET_KEY" id="i-api-key"
                                class="form-control @error('RAZORPAY_SECRET_KEY') is-invalid @enderror"
                                value="{{ old('RAZORPAY_SECRET_KEY') ?? getSetting('RAZORPAY_SECRET_KEY') }}"
                                placeholder="{{ __('Api Key') }}">
                            @error('RAZORPAY_SECRET_KEY')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-sm-6 mt-3">
                        <div class="form-group mt-2">
                            <label class="form-label" for="i-razorpay-wh-url">{{ __('Webhook URL') }}</label>
                            <div class="input-group">
                                <input type="text" dir="ltr" name="razorpay_wh_url" id="i-razorpay-wh-url"
                                    class="form-control" value="{{ route('webhooks.razorpay') }}" readonly>
                                <button class="btn btn-secondary" type="button" id="webhookUrlrazorpayCopy">
                                    {{ __('Copy') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-footer bg-transparent">
            <div class="btn-list justify-content-end">
                <button type="submit" name="submit" class="btn btn-primary mt-3">{{ __('Save') }}</button>
            </div>
        </div>
    </form>
@endsection
