@extends('admin.setting.index')

@section('setting-content')
    <form class="col-12 col-md-9 d-flex flex-column" action="{{ route('admin.setting.update-social-login') }}" method="post">
        @csrf
        <div class="card-body">
            <h2 class="mb-4">{{ __(key: 'Social Logins') }}</h2>

            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Google') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('This will enable login with google link on login page.') }}"></i>
                        </label>
                        <select name="GOOGLE_SOCIAL_LOGIN"
                            class="form-control @error('GOOGLE_SOCIAL_LOGIN') is-invalid @enderror">
                            <option value="enabled" @selected(old('GOOGLE_SOCIAL_LOGIN') ? old('GOOGLE_SOCIAL_LOGIN') == 'enabled' : getSetting('GOOGLE_SOCIAL_LOGIN') == 'enabled')>
                                {{ __('On') }}
                            </option>
                            <option value="disabled" @selected(old('GOOGLE_SOCIAL_LOGIN') ? old('GOOGLE_SOCIAL_LOGIN') == 'disabled' : getSetting('GOOGLE_SOCIAL_LOGIN') == 'disabled')>
                                {{ __('Off') }}
                            </option>
                        </select>
                        @error('GOOGLE_SOCIAL_LOGIN')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Client ID') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Client ID') }}"></i>
                        </label>
                        <input type="text" name="GOOGLE_CLIENT_ID"
                            class="form-control @error('GOOGLE_CLIENT_ID') is-invalid @enderror"
                            value="{{ old('GOOGLE_CLIENT_ID') ?? getSetting('GOOGLE_CLIENT_ID') }}"
                            placeholder="{{ __('Client ID') }}">
                        @error('GOOGLE_CLIENT_ID')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Client Secret') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Client Secret') }}"></i>
                        </label>
                        <input type="text" name="GOOGLE_CLIENT_SECRET"
                            class="form-control @error('GOOGLE_CLIENT_SECRET') is-invalid @enderror"
                            value="{{ old('GOOGLE_CLIENT_SECRET') ?? getSetting('GOOGLE_CLIENT_SECRET') }}"
                            placeholder="{{ __('Client Secret') }}">
                        @error('GOOGLE_CLIENT_SECRET')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label" for="i-callback-wh-url">{{ __('Callback URL') }}</label>
                        <div class="input-group">
                            <input type="text" dir="ltr" name="google_callback_url" id="i-google-cb-url"
                                class="form-control" value="{{ route('login.google.callback') }}" readonly>
                            <div class="btn btn-secondary" id="google_cb_url_copy">
                                {{ __('Copy') }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <hr>

            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Facebook') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('This will enable login with facebook link on login page.') }}"></i>
                        </label>
                        <select name="FACEBOOK_SOCIAL_LOGIN"
                            class="form-control @error('FACEBOOK_SOCIAL_LOGIN') is-invalid @enderror">
                            <option value="enabled" @selected(old('FACEBOOK_SOCIAL_LOGIN') ? old('FACEBOOK_SOCIAL_LOGIN') == 'enabled' : getSetting('FACEBOOK_SOCIAL_LOGIN') == 'enabled')>
                                {{ __('On') }}
                            </option>
                            <option value="disabled" @selected(old('FACEBOOK_SOCIAL_LOGIN') ? old('FACEBOOK_SOCIAL_LOGIN') == 'disabled' : getSetting('FACEBOOK_SOCIAL_LOGIN') == 'disabled')>
                                {{ __('Off') }}
                            </option>
                        </select>
                        @error('FACEBOOK_SOCIAL_LOGIN')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Client ID') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Client ID') }}"></i>
                        </label>
                        <input type="text" name="FACEBOOK_CLIENT_ID"
                            class="form-control @error('FACEBOOK_CLIENT_ID') is-invalid @enderror"
                            value="{{ old('FACEBOOK_CLIENT_ID') ?? getSetting('FACEBOOK_CLIENT_ID') }}"
                            placeholder="{{ __('Client ID') }}">
                        @error('FACEBOOK_CLIENT_ID')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Client Secret') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Client Secret') }}"></i>
                        </label>
                        <input type="text" name="FACEBOOK_CLIENT_SECRET"
                            class="form-control @error('FACEBOOK_CLIENT_SECRET') is-invalid @enderror"
                            value="{{ old('FACEBOOK_CLIENT_SECRET') ?? getSetting('FACEBOOK_CLIENT_SECRET') }}"
                            placeholder="{{ __('Client Secret') }}">
                        @error('FACEBOOK_CLIENT_SECRET')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Callback URL') }}</label>
                        <div class="input-group">
                            <input type="text" dir="ltr" name="facebook_callback_url" id="i-facebook-cb-url"
                                class="form-control" value="{{ route('login.facebook.callback') }}" readonly>
                            <div class="btn btn-secondary" id="facebook_cb_url_copy">
                                {{ __('Copy') }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <hr>

            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Linkedin') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('This will enable login with linkedin link on login page.') }}"></i>
                        </label>
                        <select name="LINKEDIN_SOCIAL_LOGIN"
                            class="form-control @error('LINKEDIN_SOCIAL_LOGIN') is-invalid @enderror">
                            <option value="enabled" @selected(old('LINKEDIN_SOCIAL_LOGIN') ? old('LINKEDIN_SOCIAL_LOGIN') == 'enabled' : getSetting('LINKEDIN_SOCIAL_LOGIN') == 'enabled')>
                                {{ __('On') }}
                            </option>
                            <option value="disabled" @selected(old('LINKEDIN_SOCIAL_LOGIN') ? old('LINKEDIN_SOCIAL_LOGIN') == 'disabled' : getSetting('LINKEDIN_SOCIAL_LOGIN') == 'disabled')>
                                {{ __('Off') }}
                            </option>
                        </select>
                        @error('LINKEDIN_SOCIAL_LOGIN')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Client ID') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Client ID') }}"></i>
                        </label>
                        <input type="text" name="LINKEDIN_CLIENT_ID"
                            class="form-control @error('LINKEDIN_CLIENT_ID') is-invalid @enderror"
                            value="{{ old('LINKEDIN_CLIENT_ID') ?? getSetting('LINKEDIN_CLIENT_ID') }}"
                            placeholder="{{ __('Client ID') }}">
                        @error('LINKEDIN_CLIENT_ID')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Client Secret') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Client Secret') }}"></i>
                        </label>
                        <input type="text" name="LINKEDIN_CLIENT_SECRET"
                            class="form-control @error('LINKEDIN_CLIENT_SECRET') is-invalid @enderror"
                            value="{{ old('LINKEDIN_CLIENT_SECRET') ?? getSetting('LINKEDIN_CLIENT_SECRET') }}"
                            placeholder="{{ __('Client Secret') }}">
                        @error('LINKEDIN_CLIENT_SECRET')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Callback URL') }}</label>
                        <div class="input-group">
                            <input type="text" dir="ltr" name="linkedin_callback_url" id="i-linkedin-cb-url"
                                class="form-control" value="{{ route('login.linkedin.callback') }}" readonly>
                            <div class="btn btn-secondary" id="linkedin_cb_url_copy">
                                {{ __('Copy') }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <hr>

            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Twitter') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('This will enable login with twitter link on login page.') }}"></i>
                        </label>
                        <select name="TWITTER_SOCIAL_LOGIN"
                            class="form-control @error('TWITTER_SOCIAL_LOGIN') is-invalid @enderror">
                            <option value="enabled" @selected(old('TWITTER_SOCIAL_LOGIN') ? old('TWITTER_SOCIAL_LOGIN') == 'enabled' : getSetting('TWITTER_SOCIAL_LOGIN') == 'enabled')>
                                {{ __('On') }}
                            </option>
                            <option value="disabled" @selected(old('TWITTER_SOCIAL_LOGIN') ? old('TWITTER_SOCIAL_LOGIN') == 'disabled' : getSetting('TWITTER_SOCIAL_LOGIN') == 'disabled')>{{ __('Off') }}
                            </option>
                        </select>
                        @error('TWITTER_SOCIAL_LOGIN')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Client ID') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Client ID') }}"></i>
                        </label>
                        <input type="text" name="TWITTER_CLIENT_ID"
                            class="form-control @error('TWITTER_CLIENT_ID') is-invalid @enderror"
                            value="{{ old('TWITTER_CLIENT_ID') ?? getSetting('TWITTER_CLIENT_ID') }}"
                            placeholder="{{ __('Client ID') }}">
                        @error('TWITTER_CLIENT_ID')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Client Secret') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Client Secret') }}"></i>
                        </label>
                        <input type="text" name="TWITTER_CLIENT_SECRET"
                            class="form-control @error('TWITTER_CLIENT_SECRET') is-invalid @enderror"
                            value="{{ old('TWITTER_CLIENT_SECRET') ?? getSetting('TWITTER_CLIENT_SECRET') }}"
                            placeholder="{{ __('Client Secret') }}">
                        @error('TWITTER_CLIENT_SECRET')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Callback URL') }}</label>
                        <div class="input-group">
                            <input type="text" dir="ltr" name="twitter_callback_url" id="i-twitter-cb-url"
                                class="form-control" value="{{ route('login.twitter.callback') }}" readonly>
                            <div class="btn btn-secondary" id="twitter_cb_url_copy">
                                {{ __('Copy') }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-footer bg-transparent">
            <div class="btn-list justify-content-end">
                <button type="submit" name="submit" class="btn btn-primary mt-3">{{ __('Save') }}</button>
            </div>
        </div>
    </form>
@endsection
