@extends('layouts.welcome')

@section('title', __('Meta title'))
@section('description', __('Meta description'))

@section('home-content')
    <div class="page jm-homepage">
        <!-- Header start here -->
        @include('include.user.header')
        <!-- Header end here-->
        <!-- meeting-join start here -->
        <div class="jm-meeting-join">
            <div class="row g-0 flex-fill">
                <div class="col-12 col-lg-6 col-sm-6 col-xl-6">
                    <!-- Photo -->
                    <div class="jm-home-bg bg-cover h-100 min-vh-100 d-flex align-items-center justify-content-center"
                        style="background-image: url(/images/background.svg)">
                        <h2 class="w-100 p-4 text-center">{!! $page->content !!}</h2>
                    </div>

                </div>
                <div class="col-12 col-lg-6 col-sm-6 col-xl-6 d-flex flex-column justify-content-center">
                    <div class="container container-tight my-5 px-lg-5">
                        <div class="jm-join-meeting justify-content-center">
                            <form id="meetingDashboard">
                                <div class="input-icon d-flex w-100">
                                    <span class="input-icon-addon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-keyboard">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path
                                                d="M2 6m0 2a2 2 0 0 1 2 -2h16a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-16a2 2 0 0 1 -2 -2z">
                                            </path>
                                            <path d="M6 10l0 .01"></path>
                                            <path d="M10 10l0 .01"></path>
                                            <path d="M14 10l0 .01"></path>
                                            <path d="M18 10l0 .01"></path>
                                            <path d="M6 14l0 .01"></path>
                                            <path d="M18 14l0 .01"></path>
                                            <path d="M10 14l4 .01"></path>
                                        </svg>
                                    </span>
                                    <input type="text" class="form-control" maxlength="9" id="conferenceId"
                                        name="id" placeholder="{{ __('Enter Meeting ID') }}" required>
                                    <button type="submit" class="link jm-join-link border-0">{{ __('JOIN') }}</button>
                                </div>
                            </form>
                        </div>
                        @if (getSetting('AUTH_MODE') == 'enabled')
                            <div class="text-secondary mt-3 d-flex justify-content-end">
                                <a class="link" href="{{ route('dashboard') }}"
                                    tabindex="-1">{{ __('Host a meeting?') }}</a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <!-- meeting-join end here -->
        @if (getSetting('LANDING_PAGE') == 'enabled')
            <!-- about start here -->
            <section class="section jm-about">
                <div class="container">
                    <div class="row">
                        <div class="col-12 col-lg-6 col-sm-6 col-xl-6">
                            <h1 class="mb-2">{{ __('About The Site') }}</h1>
                            <p class="mb-6">
                                {{ __('The application provides the ability to host video meetings without downloading any apps into your machine. Enjoy fast, secure, and high-definition video meetings with rich features such as chat, file sharing, screen sharing, and many more.') }}
                            </p>
                            <div class="jm-about-icons d-flex">
                                <div class="col d-flex flex-column justify-content-center align-items-center">
                                    <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="50" height="50"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-video">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path
                                                d="M15 10l4.553 -2.276a1 1 0 0 1 1.447 .894v6.764a1 1 0 0 1 -1.447 .894l-4.553 -2.276v-4z" />
                                            <path
                                                d="M3 6m0 2a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2z" />
                                        </svg>
                                    </span>
                                    <h4>{{ __('Host Meeting') }}</h4>
                                </div>
                                <div class="col d-flex flex-column justify-content-center align-items-center">
                                    <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-user-plus">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M8 7a4 4 0 1 0 8 0a4 4 0 0 0 -8 0"></path>
                                            <path d="M16 19h6"></path>
                                            <path d="M19 16v6"></path>
                                            <path d="M6 21v-2a4 4 0 0 1 4 -4h4"></path>
                                        </svg>
                                    </span>
                                    <h4>{{ __('Invite People') }}</h4>
                                </div>
                                <div class="col d-flex flex-column justify-content-center align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round"
                                        class="icon icon-tabler icons-tabler-outline icon-tabler-brand-youtube">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path
                                            d="M2 8a4 4 0 0 1 4 -4h12a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-12a4 4 0 0 1 -4 -4v-8z" />
                                        <path d="M10 9l5 3l-5 3z" />
                                    </svg>
                                    <h4>{{ __('Have fun') }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-lg-6 col-sm-6  col-xl-6 d-flex flex-column justify-content-center">
                            <div class="jm-about-bigicon d-flex justify-content-center align-items-center">
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round"
                                        class="icon icon-tabler icons-tabler-outline icon-tabler-video-plus">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path
                                            d="M15 10l4.553 -2.276a1 1 0 0 1 1.447 .894v6.764a1 1 0 0 1 -1.447 .894l-4.553 -2.276v-4z" />
                                        <path
                                            d="M3 6m0 2a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2z" />
                                        <path d="M7 12l4 0" />
                                        <path d="M9 10l0 4" />
                                    </svg>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- about end here -->
            <!-- Video Conference Features start here -->
            <section class="section jm-features">
                <div class="container">
                    <div class="row">
                        <div class="col-12 col-lg-12 col-xl-12">
                            <div class="d-flex justify-content-center">
                                <div class="jm-heading mb-6">
                                    <h1 class="mb-0">{{ __('Video Conference Features') }}</h1>
                                </div>
                            </div>
                        </div>
                        <!-- icon box item start -->
                        <div class="col-12 col-lg-3 col-sm-6 col-xl-3">
                            <div class="jm-icon-box d-flex p-4">
                                <div class="col d-flex flex-column justify-content-center align-items-center">
                                    <span class="d-flex justify-content-center align-items-center mb-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-users-group">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path d="M10 13a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                                            <path d="M8 21v-1a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v1" />
                                            <path d="M15 5a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                                            <path d="M17 10h2a2 2 0 0 1 2 2v1" />
                                            <path d="M5 5a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                                            <path d="M3 13v-1a2 2 0 0 1 2 -2h2" />
                                        </svg>
                                    </span>
                                    <h3 class="mb-1">{{ __('Groups') }}</h3>
                                    <p class="text-center">
                                        {{ __('Enjoy browser-based multi-user conferences without downloading any app.') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- icon box item end -->
                        <!-- icon box item start -->
                        <div class="col-12 col-lg-3 col-sm-6 col-xl-3">
                            <div class="jm-icon-box d-flex p-4">
                                <div class="col d-flex flex-column justify-content-center align-items-center">
                                    <span class="d-flex justify-content-center align-items-center mb-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-message-circle">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path
                                                d="M3 20l1.3 -3.9c-2.324 -3.437 -1.426 -7.872 2.1 -10.374c3.526 -2.501 8.59 -2.296 11.845 .48c3.255 2.777 3.695 7.266 1.029 10.501c-2.666 3.235 -7.615 4.215 -11.574 2.293l-4.7 1" />
                                        </svg>
                                    </span>
                                    <h3 class="mb-1">{{ __('In-Built Chat') }}</h3>
                                    <p class="text-center">
                                        {{ __('Share links and notes with our real-time chat feature on the go.') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- icon box item end -->
                        <!-- icon box item start -->
                        <div class="col-12 col-lg-3 col-sm-6 col-xl-3">
                            <div class="jm-icon-box d-flex p-4">
                                <div class="col d-flex flex-column justify-content-center align-items-center">
                                    <span class="d-flex justify-content-center align-items-center mb-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-screen-share">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path d="M21 12v3a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h9" />
                                            <path d="M7 20l10 0" />
                                            <path d="M9 16l0 4" />
                                            <path d="M15 16l0 4" />
                                            <path d="M17 4h4v4" />
                                            <path d="M16 9l5 -5" />
                                        </svg>
                                    </span>
                                    <h3 class="mb-1">{{ __('Screen Sharing') }}</h3>
                                    <p class="text-center">
                                        {{ __('Need to show something important during the conference? Share your screen instantly.') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- icon box item end -->
                        <!-- icon box item start -->
                        <div class="col-12 col-lg-3 col-sm-6 col-xl-3">
                            <div class="jm-icon-box d-flex p-4">
                                <div class="col d-flex flex-column justify-content-center align-items-center">
                                    <span class="d-flex justify-content-center align-items-center mb-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-files">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path d="M15 3v4a1 1 0 0 0 1 1h4" />
                                            <path
                                                d="M18 17h-7a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h4l5 5v7a2 2 0 0 1 -2 2z" />
                                            <path d="M16 17v2a2 2 0 0 1 -2 2h-7a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2" />
                                        </svg>
                                    </span>
                                    <h3 class="mb-1">{{ __('File Sharing') }}</h3>
                                    <p class="text-center">
                                        {{ __('Now you can share any media file of your choice on the go during video conferences.') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- icon box item end -->
                        <!-- icon box item start -->
                        <div class="col-12 col-lg-3 col-sm-6 col-xl-3">
                            <div class="jm-icon-box d-flex p-4">
                                <div class="col d-flex flex-column justify-content-center align-items-center">
                                    <span class="d-flex justify-content-center align-items-center mb-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-chalkboard">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path
                                                d="M8 19h-3a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v11a1 1 0 0 1 -1 1" />
                                            <path
                                                d="M11 16m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" />
                                        </svg>
                                    </span>
                                    <h3 class="mb-1">{{ __('Whiteboard') }}</h3>
                                    <p class="text-center">
                                        {{ __('Use the collaborative whiteboard to share your ideas. Draw, write & download as an image.') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- icon box item end -->
                        <!-- icon box item start -->
                        <div class="col-12 col-lg-3 col-sm-6 col-xl-3">
                            <div class="jm-icon-box d-flex p-4">
                                <div class="col d-flex flex-column justify-content-center align-items-center">
                                    <span class="d-flex justify-content-center align-items-center mb-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-circle-dot">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path d="M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0" />
                                            <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" />
                                        </svg>
                                    </span>
                                    <h3 class="mb-1">{{ __('Recording') }}</h3>
                                    <p class="text-center">
                                        {{ __('Easily record the meeting along with the screen and whiteboard, directly into your device.') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- icon box item end -->
                        <!-- icon box item start -->
                        <div class="col-12 col-lg-3 col-sm-6 col-xl-3">
                            <div class="jm-icon-box d-flex p-4">
                                <div class="col d-flex flex-column justify-content-center align-items-center">
                                    <span class="d-flex justify-content-center align-items-center mb-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-settings-cog">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path
                                                d="M12.003 21c-.732 .001 -1.465 -.438 -1.678 -1.317a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c.886 .215 1.325 .957 1.318 1.694" />
                                            <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0" />
                                            <path d="M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" />
                                            <path d="M19.001 15.5v1.5" />
                                            <path d="M19.001 21v1.5" />
                                            <path d="M22.032 17.25l-1.299 .75" />
                                            <path d="M17.27 20l-1.3 .75" />
                                            <path d="M15.97 17.25l1.3 .75" />
                                            <path d="M20.733 20l1.3 .75" />
                                        </svg>
                                    </span>
                                    <h3 class="mb-1">{{ __('Device Selection') }}</h3>
                                    <p class="text-center">
                                        {{ __('Choose which device and video quality work best for you before and after joining a meeting.') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- icon box item end -->
                        <!-- icon box item start -->
                        <div class="col-12 col-lg-3 col-sm-6 col-xl-3">
                            <div class="jm-icon-box d-flex p-4">
                                <div class="col d-flex flex-column justify-content-center align-items-center">
                                    <span class="d-flex justify-content-center align-items-center mb-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-shield-half">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path
                                                d="M12 3a12 12 0 0 0 8.5 3a12 12 0 0 1 -8.5 15a12 12 0 0 1 -8.5 -15a12 12 0 0 0 8.5 -3" />
                                            <path d="M12 3v18" />
                                        </svg>
                                    </span>
                                    <h3 class="mb-1">{{ __('End-to-End Encryption') }}</h3>
                                    <p class="text-center">
                                        {{ __('The video meetings are end-to-end encrypted so that you can relax and enjoy the meeting.') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- icon box item end -->
                    </div>
                </div>
            </section>
            <!-- Video Conference Features end here -->
            <!-- How To Host Video Meetings start here -->
            <section class="section jm-how-to-use">
                <div class="container">
                    <div class="row">
                        <div class="col-12 col-lg-12 col-xl-12">
                            <div class="d-flex justify-content-center flex-column text-center">
                                <div class="jm-heading">
                                    <h1 class="mb-3">{{ __('How To Host Video Meetings') }}</h1>
                                    <p>{{ __('Once you are logged into the system, navigate to the dashboard and create a new meeting. Then, click and the Start link and Join the meeting. When the browser prompts for media permission, then approve it. You should be inside the video meeting now.') }}
                                    </p>
                                    <p>{{ __('Invite someone by clicking on the share icon. When they enter the same meeting ID as yours, you both will be connected. Enjoy rich features such as chat, screen sharing, file sharing, etc.') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- How To Host Video Meetings end here -->
            @if (Route::has('pricing') && count(paymentGateways()) != 0 && getSetting('PAYMENT_MODE') == 'enabled')
                <!-- pricing start here -->
                <section class="section jm-pricing">
                    @include('include.user.pricing')
                </section>
                <!-- pricing end here -->
            @endif
            <!-- Frequently Asked Questions start here -->
            <section class="section jm-faq">
                <div class="container">
                    <div class="row">
                        <div class="col-12 col-lg-12 col-xl-12">
                            <div class="d-flex justify-content-between flex-column text-center">
                                <div class="jm-heading mb-6">
                                    <h1 class="mb-0">{{ __('Frequently Asked Questions') }}</h1>
                                </div>
                            </div>
                            <!-- faq  start here -->
                            <div id="faq-1" class="accordion" role="tablist" aria-multiselectable="true">
                                <div class="accordion-item">
                                    <div class="accordion-header" role="tab">
                                        <button class="accordion-button" data-bs-toggle="collapse"
                                            data-bs-target="#faq-1-1">{{ __('How secure is the video meeting?') }}</button>
                                    </div>
                                    <div id="faq-1-1" class="accordion-collapse collapse show" role="tabpanel"
                                        data-bs-parent="#faq-1">
                                        <div class="accordion-body pt-0">
                                            <div>
                                                <p>{{ __('The meetings are end-to-end encrypted. In addition, the host can set a meeting password, can decide who joins the meeting, and can kick participants out of the meeting. Which makes the meeting very secure.') }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <div class="accordion-header" role="tab">
                                        <button class="accordion-button collapsed" data-bs-toggle="collapse"
                                            data-bs-target="#faq-1-2">{{ __('How do I invite people to the meeting?') }}</button>
                                    </div>
                                    <div id="faq-1-2" class="accordion-collapse collapse" role="tabpanel"
                                        data-bs-parent="#faq-1">
                                        <div class="accordion-body pt-0">
                                            <div>
                                                <p>{{ __('You can send the meeting invite email from the dashboard or once you join the meeting, you can share the link in just one click from the meeting option buttons.') }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <div class="accordion-header" role="tab">
                                        <button class="accordion-button collapsed" data-bs-toggle="collapse"
                                            data-bs-target="#faq-1-3">{{ __('The browser is not asking for the media permission, what do I do?') }}</button>
                                    </div>
                                    <div id="faq-1-3" class="accordion-collapse collapse" role="tabpanel"
                                        data-bs-parent="#faq-1">
                                        <div class="accordion-body pt-0">
                                            <div>
                                                <p>{{ __('Make sure you have the media device attached and the browser is not blocked by your device settings. The best way is to test your media device online.') }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <div class="accordion-header" role="tab">
                                        <button class="accordion-button collapsed" data-bs-toggle="collapse"
                                            data-bs-target="#faq-1-4">{{ __('I can not see the other person, why?') }}</button>
                                    </div>
                                    <div id="faq-1-4" class="accordion-collapse collapse" role="tabpanel"
                                        data-bs-parent="#faq-1">
                                        <div class="accordion-body pt-0">
                                            <div>
                                                <p>{{ __('Make sure you both are in the same meeting. If you are the host, check the dialog in the upper right corner where you can accept the participant`s request.') }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- faq start here -->
                        </div>
                    </div>
                </div>
            </section>
            <!-- Frequently Asked Questions end here -->
            <!-- 5-Star Rated Application start here -->
            <section class="section jm-reviews">
                <div class="container">
                    <div class="row">
                        <div class="col-12 col-lg-12 col-xl-12">
                            <div class="d-flex justify-content-center flex-column text-center">
                                <div class="jm-heading">
                                    <div class="jm-review-icon d-flex align-items-center justify-content-center mb-4">
                                        <span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="currentColor"
                                                class="icon icon-tabler icons-tabler-filled icon-tabler-carambola">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path
                                                    d="M17.108 22.085c-1.266 -.068 -2.924 -.859 -5.071 -2.355l-.04 -.027l-.037 .027c-2.147 1.497 -3.804 2.288 -5.072 2.356l-.178 .005c-2.747 0 -3.097 -2.64 -1.718 -7.244l.054 -.178l-.1 -.075c-6.056 -4.638 -5.046 -7.848 2.554 -8.066l.202 -.005l.115 -.326c1.184 -3.33 2.426 -5.085 4.027 -5.192l.156 -.005c1.674 0 2.957 1.76 4.182 5.197l.114 .326l.204 .005c7.6 .218 8.61 3.428 2.553 8.065l-.102 .075l.055 .178c1.35 4.512 1.04 7.137 -1.556 7.24l-.163 .003z" />
                                            </svg></span>
                                        <span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="currentColor"
                                                class="icon icon-tabler icons-tabler-filled icon-tabler-carambola">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path
                                                    d="M17.108 22.085c-1.266 -.068 -2.924 -.859 -5.071 -2.355l-.04 -.027l-.037 .027c-2.147 1.497 -3.804 2.288 -5.072 2.356l-.178 .005c-2.747 0 -3.097 -2.64 -1.718 -7.244l.054 -.178l-.1 -.075c-6.056 -4.638 -5.046 -7.848 2.554 -8.066l.202 -.005l.115 -.326c1.184 -3.33 2.426 -5.085 4.027 -5.192l.156 -.005c1.674 0 2.957 1.76 4.182 5.197l.114 .326l.204 .005c7.6 .218 8.61 3.428 2.553 8.065l-.102 .075l.055 .178c1.35 4.512 1.04 7.137 -1.556 7.24l-.163 .003z" />
                                            </svg></span>
                                        <span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="currentColor"
                                                class="icon icon-tabler icons-tabler-filled icon-tabler-carambola">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path
                                                    d="M17.108 22.085c-1.266 -.068 -2.924 -.859 -5.071 -2.355l-.04 -.027l-.037 .027c-2.147 1.497 -3.804 2.288 -5.072 2.356l-.178 .005c-2.747 0 -3.097 -2.64 -1.718 -7.244l.054 -.178l-.1 -.075c-6.056 -4.638 -5.046 -7.848 2.554 -8.066l.202 -.005l.115 -.326c1.184 -3.33 2.426 -5.085 4.027 -5.192l.156 -.005c1.674 0 2.957 1.76 4.182 5.197l.114 .326l.204 .005c7.6 .218 8.61 3.428 2.553 8.065l-.102 .075l.055 .178c1.35 4.512 1.04 7.137 -1.556 7.24l-.163 .003z" />
                                            </svg></span>
                                        <span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="currentColor"
                                                class="icon icon-tabler icons-tabler-filled icon-tabler-carambola">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path
                                                    d="M17.108 22.085c-1.266 -.068 -2.924 -.859 -5.071 -2.355l-.04 -.027l-.037 .027c-2.147 1.497 -3.804 2.288 -5.072 2.356l-.178 .005c-2.747 0 -3.097 -2.64 -1.718 -7.244l.054 -.178l-.1 -.075c-6.056 -4.638 -5.046 -7.848 2.554 -8.066l.202 -.005l.115 -.326c1.184 -3.33 2.426 -5.085 4.027 -5.192l.156 -.005c1.674 0 2.957 1.76 4.182 5.197l.114 .326l.204 .005c7.6 .218 8.61 3.428 2.553 8.065l-.102 .075l.055 .178c1.35 4.512 1.04 7.137 -1.556 7.24l-.163 .003z" />
                                            </svg></span>
                                        <span><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="currentColor"
                                                class="icon icon-tabler icons-tabler-filled icon-tabler-carambola">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path
                                                    d="M17.108 22.085c-1.266 -.068 -2.924 -.859 -5.071 -2.355l-.04 -.027l-.037 .027c-2.147 1.497 -3.804 2.288 -5.072 2.356l-.178 .005c-2.747 0 -3.097 -2.64 -1.718 -7.244l.054 -.178l-.1 -.075c-6.056 -4.638 -5.046 -7.848 2.554 -8.066l.202 -.005l.115 -.326c1.184 -3.33 2.426 -5.085 4.027 -5.192l.156 -.005c1.674 0 2.957 1.76 4.182 5.197l.114 .326l.204 .005c7.6 .218 8.61 3.428 2.553 8.065l-.102 .075l.055 .178c1.35 4.512 1.04 7.137 -1.556 7.24l-.163 .003z" />
                                            </svg></span>
                                    </div>
                                    <h1 class="mb-3">{{ __('5-Star Rated Application') }}</h1>
                                    <p class="m-0">
                                        {{ __('The application is the best way to host video meetings online. The easy-to-use features make it more convenient to use this application for users. Try hosting a meeting now, you will get to know how easy to use the features are.') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- 5-Star Rated Application end here -->
            <!-- How To Host Video Meetings start here -->
            <section class="section jm-how-to-use">
                <div class="container">
                    <div class="row">
                        <div class="col-12 col-lg-12 col-xl-12">
                            <div class="d-flex justify-content-center flex-column text-center">
                                <div class="jm-heading">
                                    <h1 class="mb-3">{{ __('What are you waiting for? Host a meeting now.') }} </h1>
                                    <a href="#" class="btn btn-outline-light btn-lg">{{ __('Start now') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        @endif
        @if (getSetting('PWA') == 'enabled')
            @include('include.pwa-installation-modal')

            <script type="text/javascript">
                if ('serviceWorker' in navigator) {
                    navigator.serviceWorker.register('/serviceworker.js', {
                        scope: '.'
                    }).then(function(registration) {}, function(err) {});
                }
            </script>
        @endif
        @include('include.cookie')
        <!-- How To Host Video Meetings end here -->
        <!-- footer start here -->
        @include('include.user.footer')
        <!-- footer end here -->
    </div>
@endsection
