@extends('user.profile.index')

@section('profile-content')
    <form {{-- action="{{ route('user.profile.upgrade-plan') }}" --}} method="post" class="col-12 col-md-9 d-flex flex-column showToastAbove">
        @csrf
        <div class="card-body">
            <h2 class="mb-4">{{ __('Plans') }}</h2>
            @include('include.user.message')
            <div class="row">
                <div class="col-12 col-lg-6 mb-3">
                    <div class="text-muted">{{ __('Plan') }}</div>
                    <div>{{ $user->plan->name }}</div>
                </div>

                @if (!$user->planOnDefault())
                    @if ($user->plan_payment_gateway)
                        <div class="col-12 col-lg-6 mb-3">
                            <div class="text-muted">{{ __('Gateway') }}</div>
                            <div>{!! ucwords($user->plan_payment_gateway) !!}</div>
                        </div>
                    @endif

                    @if ($user->plan_amount && $user->plan_currency && $user->plan_interval)
                        <div class="col-12 col-lg-6 mb-3">
                            <div class="text-muted">{{ __('Amount') }}</div>
                            <div>
                                {{ formatMoney($user->plan_amount, $user->plan_currency) }}
                                {{ $user->plan_currency }} /
                                <span
                                    class="text-lowercase">{{ $user->plan_interval == 'month' || $user->plan_interval == 'monthly' ? __('Month') : __('Year') }}</span>
                            </div>
                        </div>
                    @endif

                    @if ($user->plan_recurring_at)
                        <div class="col-12 col-lg-6 mb-3">
                            <div class="text-muted">{{ __('Recurring at') }}
                            </div>
                            <div>{{ $user->plan_recurring_at }}</div>
                        </div>
                    @endif

                    @if ($user->plan_trial_ends_at && $user->plan_trial_ends_at->gt(Carbon\Carbon::now()))
                        <div class="col-12 col-lg-6 mb-3">
                            <div class="text-muted">{{ __('Trial ends at') }}
                            </div>
                            <div>{{ $user->plan_trial_ends_at }}</div>
                        </div>
                    @endif

                    @if ($user->plan_ends_at)
                        <div class="col-12 col-lg-6 mb-3">
                            <div class="text-muted">{{ __('Ends at') }}</div>
                            <div>{{ $user->plan_ends_at }}</div>
                        </div>
                    @endif
                @endif
            </div>
            @if ($user->plan_recurring_at)
                <button type="button" class="btn btn-outline-danger mb-3" data-bs-toggle="modal"
                    data-bs-target="#cancel-modal">{{ __('Cancel') }}</button>
            @endif

            @if (getAuthUserInfo('role') != 'admin' && showUpgrade())
                <a href="{{ route('pricing') }}">
                    <button type="button" name="submit" class="btn btn-primary mb-3">{{ __('Upgrade') }}</button>
                </a>
            @endif
    </form>
    <div class="modal fade" id="cancel-modal" tabindex="-1" role="dialog" aria-labelledby="cancel-modal-label"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content border-0 shadow">
                <div class="modal-header">
                    <h6 class="modal-title" id="cancel-modal-label">
                        {{ __('Cancel') }}</h6>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        {{ __('You will continue to have access to the features you have paid for until the end of your billing cycle.') }}
                    </div>
                    <div>
                        {{ __('Are you sure you want to cancel :name?', ['name' => $user->plan->name]) }}
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <form action="{{ route('user.profile.cancel-plan') }}" method="post">

                        @csrf

                        <button type="submit" class="btn btn-danger">{{ __('Cancel') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection
