import { EnhancedEventEmitter } from './enhancedEvents';
import type { Channel } from './Channel';
import type { Router, PipeToRouterOptions, PipeToRouterResult, PipeTransportPair, RouterDump, RouterEvents, RouterObserver } from './RouterTypes';
import type { Transport } from './TransportTypes';
import type { WebRtcTransport, WebRtcTransportOptions } from './WebRtcTransportTypes';
import type { PlainTransport, PlainTransportOptions } from './PlainTransportTypes';
import type { PipeTransport, PipeTransportOptions } from './PipeTransportTypes';
import type { DirectTransport, DirectTransportOptions } from './DirectTransportTypes';
import type { ActiveSpeakerObserver, ActiveSpeakerObserverOptions } from './ActiveSpeakerObserverTypes';
import type { AudioLevelObserver, AudioLevelObserverOptions } from './AudioLevelObserverTypes';
import type { RtpCapabilities } from './rtpParametersTypes';
import type { AppData } from './types';
import * as FbsRouter from './fbs/router';
export type RouterInternal = {
    routerId: string;
};
type RouterData = {
    rtpCapabilities: RtpCapabilities;
};
export declare class RouterImpl<RouterAppData extends AppData = AppData> extends EnhancedEventEmitter<RouterEvents> implements Router {
    #private;
    constructor({ internal, data, channel, appData, }: {
        internal: RouterInternal;
        data: RouterData;
        channel: Channel;
        appData?: RouterAppData;
    });
    get id(): string;
    get closed(): boolean;
    get rtpCapabilities(): RtpCapabilities;
    get appData(): RouterAppData;
    set appData(appData: RouterAppData);
    get observer(): RouterObserver;
    /**
     * Just for testing purposes.
     *
     * @private
     */
    get transportsForTesting(): Map<string, Transport>;
    close(): void;
    workerClosed(): void;
    dump(): Promise<RouterDump>;
    createWebRtcTransport<WebRtcTransportAppData extends AppData = AppData>({ webRtcServer, listenInfos, listenIps, port, enableUdp, enableTcp, preferUdp, preferTcp, initialAvailableOutgoingBitrate, enableSctp, numSctpStreams, maxSctpMessageSize, sctpSendBufferSize, iceConsentTimeout, appData, }: WebRtcTransportOptions<WebRtcTransportAppData>): Promise<WebRtcTransport<WebRtcTransportAppData>>;
    createPlainTransport<PlainTransportAppData extends AppData = AppData>({ listenInfo, rtcpListenInfo, listenIp, port, rtcpMux, comedia, enableSctp, numSctpStreams, maxSctpMessageSize, sctpSendBufferSize, enableSrtp, srtpCryptoSuite, appData, }: PlainTransportOptions<PlainTransportAppData>): Promise<PlainTransport<PlainTransportAppData>>;
    createPipeTransport<PipeTransportAppData extends AppData = AppData>({ listenInfo, listenIp, port, enableSctp, numSctpStreams, maxSctpMessageSize, sctpSendBufferSize, enableRtx, enableSrtp, appData, }: PipeTransportOptions<PipeTransportAppData>): Promise<PipeTransport<PipeTransportAppData>>;
    createDirectTransport<DirectTransportAppData extends AppData = AppData>({ maxMessageSize, appData, }?: DirectTransportOptions<DirectTransportAppData>): Promise<DirectTransport<DirectTransportAppData>>;
    pipeToRouter({ producerId, dataProducerId, router, listenInfo, listenIp, enableSctp, numSctpStreams, enableRtx, enableSrtp, }: PipeToRouterOptions): Promise<PipeToRouterResult>;
    addPipeTransportPair(pipeTransportPairKey: string, pipeTransportPairPromise: Promise<PipeTransportPair>): void;
    createActiveSpeakerObserver<ActiveSpeakerObserverAppData extends AppData = AppData>({ interval, appData, }?: ActiveSpeakerObserverOptions<ActiveSpeakerObserverAppData>): Promise<ActiveSpeakerObserver<ActiveSpeakerObserverAppData>>;
    createAudioLevelObserver<AudioLevelObserverAppData extends AppData = AppData>({ maxEntries, threshold, interval, appData, }?: AudioLevelObserverOptions<AudioLevelObserverAppData>): Promise<AudioLevelObserver<AudioLevelObserverAppData>>;
    canConsume({ producerId, rtpCapabilities, }: {
        producerId: string;
        rtpCapabilities: RtpCapabilities;
    }): boolean;
    private handleListenerError;
}
export declare function parseRouterDumpResponse(binary: FbsRouter.DumpResponse): RouterDump;
export {};
//# sourceMappingURL=Router.d.ts.map