"use strict";
// automatically generated by the FlatBuffers compiler, do not modify
Object.defineProperty(exports, "__esModule", { value: true });
exports.DumpResponseT = exports.DumpResponse = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any, @typescript-eslint/no-non-null-assertion */
const flatbuffers = require("flatbuffers");
const media_kind_1 = require("../../fbs/rtp-parameters/media-kind");
const rtp_mapping_1 = require("../../fbs/rtp-parameters/rtp-mapping");
const rtp_parameters_1 = require("../../fbs/rtp-parameters/rtp-parameters");
const type_1 = require("../../fbs/rtp-parameters/type");
const dump_1 = require("../../fbs/rtp-stream/dump");
class DumpResponse {
    bb = null;
    bb_pos = 0;
    __init(i, bb) {
        this.bb_pos = i;
        this.bb = bb;
        return this;
    }
    static getRootAsDumpResponse(bb, obj) {
        return (obj || new DumpResponse()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    static getSizePrefixedRootAsDumpResponse(bb, obj) {
        bb.setPosition(bb.position() + flatbuffers.SIZE_PREFIX_LENGTH);
        return (obj || new DumpResponse()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    id(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    kind() {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : media_kind_1.MediaKind.AUDIO;
    }
    type() {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : type_1.Type.SIMPLE;
    }
    rtpParameters(obj) {
        const offset = this.bb.__offset(this.bb_pos, 10);
        return offset ? (obj || new rtp_parameters_1.RtpParameters()).__init(this.bb.__indirect(this.bb_pos + offset), this.bb) : null;
    }
    rtpMapping(obj) {
        const offset = this.bb.__offset(this.bb_pos, 12);
        return offset ? (obj || new rtp_mapping_1.RtpMapping()).__init(this.bb.__indirect(this.bb_pos + offset), this.bb) : null;
    }
    rtpStreams(index, obj) {
        const offset = this.bb.__offset(this.bb_pos, 14);
        return offset ? (obj || new dump_1.Dump()).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos + offset) + index * 4), this.bb) : null;
    }
    rtpStreamsLength() {
        const offset = this.bb.__offset(this.bb_pos, 14);
        return offset ? this.bb.__vector_len(this.bb_pos + offset) : 0;
    }
    traceEventTypes(index) {
        const offset = this.bb.__offset(this.bb_pos, 16);
        return offset ? this.bb.readUint8(this.bb.__vector(this.bb_pos + offset) + index) : 0;
    }
    traceEventTypesLength() {
        const offset = this.bb.__offset(this.bb_pos, 16);
        return offset ? this.bb.__vector_len(this.bb_pos + offset) : 0;
    }
    traceEventTypesArray() {
        const offset = this.bb.__offset(this.bb_pos, 16);
        return offset ? new Uint8Array(this.bb.bytes().buffer, this.bb.bytes().byteOffset + this.bb.__vector(this.bb_pos + offset), this.bb.__vector_len(this.bb_pos + offset)) : null;
    }
    paused() {
        const offset = this.bb.__offset(this.bb_pos, 18);
        return offset ? !!this.bb.readInt8(this.bb_pos + offset) : false;
    }
    static startDumpResponse(builder) {
        builder.startObject(8);
    }
    static addId(builder, idOffset) {
        builder.addFieldOffset(0, idOffset, 0);
    }
    static addKind(builder, kind) {
        builder.addFieldInt8(1, kind, media_kind_1.MediaKind.AUDIO);
    }
    static addType(builder, type) {
        builder.addFieldInt8(2, type, type_1.Type.SIMPLE);
    }
    static addRtpParameters(builder, rtpParametersOffset) {
        builder.addFieldOffset(3, rtpParametersOffset, 0);
    }
    static addRtpMapping(builder, rtpMappingOffset) {
        builder.addFieldOffset(4, rtpMappingOffset, 0);
    }
    static addRtpStreams(builder, rtpStreamsOffset) {
        builder.addFieldOffset(5, rtpStreamsOffset, 0);
    }
    static createRtpStreamsVector(builder, data) {
        builder.startVector(4, data.length, 4);
        for (let i = data.length - 1; i >= 0; i--) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }
    static startRtpStreamsVector(builder, numElems) {
        builder.startVector(4, numElems, 4);
    }
    static addTraceEventTypes(builder, traceEventTypesOffset) {
        builder.addFieldOffset(6, traceEventTypesOffset, 0);
    }
    static createTraceEventTypesVector(builder, data) {
        builder.startVector(1, data.length, 1);
        for (let i = data.length - 1; i >= 0; i--) {
            builder.addInt8(data[i]);
        }
        return builder.endVector();
    }
    static startTraceEventTypesVector(builder, numElems) {
        builder.startVector(1, numElems, 1);
    }
    static addPaused(builder, paused) {
        builder.addFieldInt8(7, +paused, +false);
    }
    static endDumpResponse(builder) {
        const offset = builder.endObject();
        builder.requiredField(offset, 4); // id
        builder.requiredField(offset, 10); // rtp_parameters
        builder.requiredField(offset, 12); // rtp_mapping
        builder.requiredField(offset, 14); // rtp_streams
        builder.requiredField(offset, 16); // trace_event_types
        return offset;
    }
    unpack() {
        return new DumpResponseT(this.id(), this.kind(), this.type(), (this.rtpParameters() !== null ? this.rtpParameters().unpack() : null), (this.rtpMapping() !== null ? this.rtpMapping().unpack() : null), this.bb.createObjList(this.rtpStreams.bind(this), this.rtpStreamsLength()), this.bb.createScalarList(this.traceEventTypes.bind(this), this.traceEventTypesLength()), this.paused());
    }
    unpackTo(_o) {
        _o.id = this.id();
        _o.kind = this.kind();
        _o.type = this.type();
        _o.rtpParameters = (this.rtpParameters() !== null ? this.rtpParameters().unpack() : null);
        _o.rtpMapping = (this.rtpMapping() !== null ? this.rtpMapping().unpack() : null);
        _o.rtpStreams = this.bb.createObjList(this.rtpStreams.bind(this), this.rtpStreamsLength());
        _o.traceEventTypes = this.bb.createScalarList(this.traceEventTypes.bind(this), this.traceEventTypesLength());
        _o.paused = this.paused();
    }
}
exports.DumpResponse = DumpResponse;
class DumpResponseT {
    id;
    kind;
    type;
    rtpParameters;
    rtpMapping;
    rtpStreams;
    traceEventTypes;
    paused;
    constructor(id = null, kind = media_kind_1.MediaKind.AUDIO, type = type_1.Type.SIMPLE, rtpParameters = null, rtpMapping = null, rtpStreams = [], traceEventTypes = [], paused = false) {
        this.id = id;
        this.kind = kind;
        this.type = type;
        this.rtpParameters = rtpParameters;
        this.rtpMapping = rtpMapping;
        this.rtpStreams = rtpStreams;
        this.traceEventTypes = traceEventTypes;
        this.paused = paused;
    }
    pack(builder) {
        const id = (this.id !== null ? builder.createString(this.id) : 0);
        const rtpParameters = (this.rtpParameters !== null ? this.rtpParameters.pack(builder) : 0);
        const rtpMapping = (this.rtpMapping !== null ? this.rtpMapping.pack(builder) : 0);
        const rtpStreams = DumpResponse.createRtpStreamsVector(builder, builder.createObjectOffsetList(this.rtpStreams));
        const traceEventTypes = DumpResponse.createTraceEventTypesVector(builder, this.traceEventTypes);
        DumpResponse.startDumpResponse(builder);
        DumpResponse.addId(builder, id);
        DumpResponse.addKind(builder, this.kind);
        DumpResponse.addType(builder, this.type);
        DumpResponse.addRtpParameters(builder, rtpParameters);
        DumpResponse.addRtpMapping(builder, rtpMapping);
        DumpResponse.addRtpStreams(builder, rtpStreams);
        DumpResponse.addTraceEventTypes(builder, traceEventTypes);
        DumpResponse.addPaused(builder, this.paused);
        return DumpResponse.endDumpResponse(builder);
    }
}
exports.DumpResponseT = DumpResponseT;
