"use strict";
// automatically generated by the FlatBuffers compiler, do not modify
Object.defineProperty(exports, "__esModule", { value: true });
exports.RtpHeaderExtensionParametersT = exports.RtpHeaderExtensionParameters = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any, @typescript-eslint/no-non-null-assertion */
const flatbuffers = require("flatbuffers");
const parameter_1 = require("../../fbs/rtp-parameters/parameter");
const rtp_header_extension_uri_1 = require("../../fbs/rtp-parameters/rtp-header-extension-uri");
class RtpHeaderExtensionParameters {
    bb = null;
    bb_pos = 0;
    __init(i, bb) {
        this.bb_pos = i;
        this.bb = bb;
        return this;
    }
    static getRootAsRtpHeaderExtensionParameters(bb, obj) {
        return (obj || new RtpHeaderExtensionParameters()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    static getSizePrefixedRootAsRtpHeaderExtensionParameters(bb, obj) {
        bb.setPosition(bb.position() + flatbuffers.SIZE_PREFIX_LENGTH);
        return (obj || new RtpHeaderExtensionParameters()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    uri() {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : rtp_header_extension_uri_1.RtpHeaderExtensionUri.Mid;
    }
    id() {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : 0;
    }
    encrypt() {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? !!this.bb.readInt8(this.bb_pos + offset) : false;
    }
    parameters(index, obj) {
        const offset = this.bb.__offset(this.bb_pos, 10);
        return offset ? (obj || new parameter_1.Parameter()).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos + offset) + index * 4), this.bb) : null;
    }
    parametersLength() {
        const offset = this.bb.__offset(this.bb_pos, 10);
        return offset ? this.bb.__vector_len(this.bb_pos + offset) : 0;
    }
    static startRtpHeaderExtensionParameters(builder) {
        builder.startObject(4);
    }
    static addUri(builder, uri) {
        builder.addFieldInt8(0, uri, rtp_header_extension_uri_1.RtpHeaderExtensionUri.Mid);
    }
    static addId(builder, id) {
        builder.addFieldInt8(1, id, 0);
    }
    static addEncrypt(builder, encrypt) {
        builder.addFieldInt8(2, +encrypt, +false);
    }
    static addParameters(builder, parametersOffset) {
        builder.addFieldOffset(3, parametersOffset, 0);
    }
    static createParametersVector(builder, data) {
        builder.startVector(4, data.length, 4);
        for (let i = data.length - 1; i >= 0; i--) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }
    static startParametersVector(builder, numElems) {
        builder.startVector(4, numElems, 4);
    }
    static endRtpHeaderExtensionParameters(builder) {
        const offset = builder.endObject();
        return offset;
    }
    static createRtpHeaderExtensionParameters(builder, uri, id, encrypt, parametersOffset) {
        RtpHeaderExtensionParameters.startRtpHeaderExtensionParameters(builder);
        RtpHeaderExtensionParameters.addUri(builder, uri);
        RtpHeaderExtensionParameters.addId(builder, id);
        RtpHeaderExtensionParameters.addEncrypt(builder, encrypt);
        RtpHeaderExtensionParameters.addParameters(builder, parametersOffset);
        return RtpHeaderExtensionParameters.endRtpHeaderExtensionParameters(builder);
    }
    unpack() {
        return new RtpHeaderExtensionParametersT(this.uri(), this.id(), this.encrypt(), this.bb.createObjList(this.parameters.bind(this), this.parametersLength()));
    }
    unpackTo(_o) {
        _o.uri = this.uri();
        _o.id = this.id();
        _o.encrypt = this.encrypt();
        _o.parameters = this.bb.createObjList(this.parameters.bind(this), this.parametersLength());
    }
}
exports.RtpHeaderExtensionParameters = RtpHeaderExtensionParameters;
class RtpHeaderExtensionParametersT {
    uri;
    id;
    encrypt;
    parameters;
    constructor(uri = rtp_header_extension_uri_1.RtpHeaderExtensionUri.Mid, id = 0, encrypt = false, parameters = []) {
        this.uri = uri;
        this.id = id;
        this.encrypt = encrypt;
        this.parameters = parameters;
    }
    pack(builder) {
        const parameters = RtpHeaderExtensionParameters.createParametersVector(builder, builder.createObjectOffsetList(this.parameters));
        return RtpHeaderExtensionParameters.createRtpHeaderExtensionParameters(builder, this.uri, this.id, this.encrypt, parameters);
    }
}
exports.RtpHeaderExtensionParametersT = RtpHeaderExtensionParametersT;
