import * as flatbuffers from 'flatbuffers';
import { MediaKind } from '../../fbs/rtp-parameters/media-kind';
export declare class BaseStats implements flatbuffers.IUnpackableObject<BaseStatsT> {
    bb: flatbuffers.ByteBuffer | null;
    bb_pos: number;
    __init(i: number, bb: flatbuffers.ByteBuffer): BaseStats;
    static getRootAsBaseStats(bb: flatbuffers.ByteBuffer, obj?: BaseStats): BaseStats;
    static getSizePrefixedRootAsBaseStats(bb: flatbuffers.ByteBuffer, obj?: BaseStats): BaseStats;
    timestamp(): bigint;
    ssrc(): number;
    kind(): MediaKind;
    mimeType(): string | null;
    mimeType(optionalEncoding: flatbuffers.Encoding): string | Uint8Array | null;
    packetsLost(): bigint;
    fractionLost(): number;
    packetsDiscarded(): bigint;
    packetsRetransmitted(): bigint;
    packetsRepaired(): bigint;
    nackCount(): bigint;
    nackPacketCount(): bigint;
    pliCount(): bigint;
    firCount(): bigint;
    score(): number;
    rid(): string | null;
    rid(optionalEncoding: flatbuffers.Encoding): string | Uint8Array | null;
    rtxSsrc(): number | null;
    rtxPacketsDiscarded(): bigint;
    roundTripTime(): number;
    static startBaseStats(builder: flatbuffers.Builder): void;
    static addTimestamp(builder: flatbuffers.Builder, timestamp: bigint): void;
    static addSsrc(builder: flatbuffers.Builder, ssrc: number): void;
    static addKind(builder: flatbuffers.Builder, kind: MediaKind): void;
    static addMimeType(builder: flatbuffers.Builder, mimeTypeOffset: flatbuffers.Offset): void;
    static addPacketsLost(builder: flatbuffers.Builder, packetsLost: bigint): void;
    static addFractionLost(builder: flatbuffers.Builder, fractionLost: number): void;
    static addPacketsDiscarded(builder: flatbuffers.Builder, packetsDiscarded: bigint): void;
    static addPacketsRetransmitted(builder: flatbuffers.Builder, packetsRetransmitted: bigint): void;
    static addPacketsRepaired(builder: flatbuffers.Builder, packetsRepaired: bigint): void;
    static addNackCount(builder: flatbuffers.Builder, nackCount: bigint): void;
    static addNackPacketCount(builder: flatbuffers.Builder, nackPacketCount: bigint): void;
    static addPliCount(builder: flatbuffers.Builder, pliCount: bigint): void;
    static addFirCount(builder: flatbuffers.Builder, firCount: bigint): void;
    static addScore(builder: flatbuffers.Builder, score: number): void;
    static addRid(builder: flatbuffers.Builder, ridOffset: flatbuffers.Offset): void;
    static addRtxSsrc(builder: flatbuffers.Builder, rtxSsrc: number): void;
    static addRtxPacketsDiscarded(builder: flatbuffers.Builder, rtxPacketsDiscarded: bigint): void;
    static addRoundTripTime(builder: flatbuffers.Builder, roundTripTime: number): void;
    static endBaseStats(builder: flatbuffers.Builder): flatbuffers.Offset;
    static createBaseStats(builder: flatbuffers.Builder, timestamp: bigint, ssrc: number, kind: MediaKind, mimeTypeOffset: flatbuffers.Offset, packetsLost: bigint, fractionLost: number, packetsDiscarded: bigint, packetsRetransmitted: bigint, packetsRepaired: bigint, nackCount: bigint, nackPacketCount: bigint, pliCount: bigint, firCount: bigint, score: number, ridOffset: flatbuffers.Offset, rtxSsrc: number | null, rtxPacketsDiscarded: bigint, roundTripTime: number): flatbuffers.Offset;
    unpack(): BaseStatsT;
    unpackTo(_o: BaseStatsT): void;
}
export declare class BaseStatsT implements flatbuffers.IGeneratedObject {
    timestamp: bigint;
    ssrc: number;
    kind: MediaKind;
    mimeType: string | Uint8Array | null;
    packetsLost: bigint;
    fractionLost: number;
    packetsDiscarded: bigint;
    packetsRetransmitted: bigint;
    packetsRepaired: bigint;
    nackCount: bigint;
    nackPacketCount: bigint;
    pliCount: bigint;
    firCount: bigint;
    score: number;
    rid: string | Uint8Array | null;
    rtxSsrc: number | null;
    rtxPacketsDiscarded: bigint;
    roundTripTime: number;
    constructor(timestamp?: bigint, ssrc?: number, kind?: MediaKind, mimeType?: string | Uint8Array | null, packetsLost?: bigint, fractionLost?: number, packetsDiscarded?: bigint, packetsRetransmitted?: bigint, packetsRepaired?: bigint, nackCount?: bigint, nackPacketCount?: bigint, pliCount?: bigint, firCount?: bigint, score?: number, rid?: string | Uint8Array | null, rtxSsrc?: number | null, rtxPacketsDiscarded?: bigint, roundTripTime?: number);
    pack(builder: flatbuffers.Builder): flatbuffers.Offset;
}
//# sourceMappingURL=base-stats.d.ts.map