"use strict";
// automatically generated by the FlatBuffers compiler, do not modify
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProduceRequestT = exports.ProduceRequest = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any, @typescript-eslint/no-non-null-assertion */
const flatbuffers = require("flatbuffers");
const media_kind_1 = require("../../fbs/rtp-parameters/media-kind");
const rtp_mapping_1 = require("../../fbs/rtp-parameters/rtp-mapping");
const rtp_parameters_1 = require("../../fbs/rtp-parameters/rtp-parameters");
class ProduceRequest {
    bb = null;
    bb_pos = 0;
    __init(i, bb) {
        this.bb_pos = i;
        this.bb = bb;
        return this;
    }
    static getRootAsProduceRequest(bb, obj) {
        return (obj || new ProduceRequest()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    static getSizePrefixedRootAsProduceRequest(bb, obj) {
        bb.setPosition(bb.position() + flatbuffers.SIZE_PREFIX_LENGTH);
        return (obj || new ProduceRequest()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    producerId(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    kind() {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : media_kind_1.MediaKind.AUDIO;
    }
    rtpParameters(obj) {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? (obj || new rtp_parameters_1.RtpParameters()).__init(this.bb.__indirect(this.bb_pos + offset), this.bb) : null;
    }
    rtpMapping(obj) {
        const offset = this.bb.__offset(this.bb_pos, 10);
        return offset ? (obj || new rtp_mapping_1.RtpMapping()).__init(this.bb.__indirect(this.bb_pos + offset), this.bb) : null;
    }
    keyFrameRequestDelay() {
        const offset = this.bb.__offset(this.bb_pos, 12);
        return offset ? this.bb.readUint32(this.bb_pos + offset) : 0;
    }
    paused() {
        const offset = this.bb.__offset(this.bb_pos, 14);
        return offset ? !!this.bb.readInt8(this.bb_pos + offset) : false;
    }
    static startProduceRequest(builder) {
        builder.startObject(6);
    }
    static addProducerId(builder, producerIdOffset) {
        builder.addFieldOffset(0, producerIdOffset, 0);
    }
    static addKind(builder, kind) {
        builder.addFieldInt8(1, kind, media_kind_1.MediaKind.AUDIO);
    }
    static addRtpParameters(builder, rtpParametersOffset) {
        builder.addFieldOffset(2, rtpParametersOffset, 0);
    }
    static addRtpMapping(builder, rtpMappingOffset) {
        builder.addFieldOffset(3, rtpMappingOffset, 0);
    }
    static addKeyFrameRequestDelay(builder, keyFrameRequestDelay) {
        builder.addFieldInt32(4, keyFrameRequestDelay, 0);
    }
    static addPaused(builder, paused) {
        builder.addFieldInt8(5, +paused, +false);
    }
    static endProduceRequest(builder) {
        const offset = builder.endObject();
        builder.requiredField(offset, 4); // producer_id
        builder.requiredField(offset, 8); // rtp_parameters
        builder.requiredField(offset, 10); // rtp_mapping
        return offset;
    }
    unpack() {
        return new ProduceRequestT(this.producerId(), this.kind(), (this.rtpParameters() !== null ? this.rtpParameters().unpack() : null), (this.rtpMapping() !== null ? this.rtpMapping().unpack() : null), this.keyFrameRequestDelay(), this.paused());
    }
    unpackTo(_o) {
        _o.producerId = this.producerId();
        _o.kind = this.kind();
        _o.rtpParameters = (this.rtpParameters() !== null ? this.rtpParameters().unpack() : null);
        _o.rtpMapping = (this.rtpMapping() !== null ? this.rtpMapping().unpack() : null);
        _o.keyFrameRequestDelay = this.keyFrameRequestDelay();
        _o.paused = this.paused();
    }
}
exports.ProduceRequest = ProduceRequest;
class ProduceRequestT {
    producerId;
    kind;
    rtpParameters;
    rtpMapping;
    keyFrameRequestDelay;
    paused;
    constructor(producerId = null, kind = media_kind_1.MediaKind.AUDIO, rtpParameters = null, rtpMapping = null, keyFrameRequestDelay = 0, paused = false) {
        this.producerId = producerId;
        this.kind = kind;
        this.rtpParameters = rtpParameters;
        this.rtpMapping = rtpMapping;
        this.keyFrameRequestDelay = keyFrameRequestDelay;
        this.paused = paused;
    }
    pack(builder) {
        const producerId = (this.producerId !== null ? builder.createString(this.producerId) : 0);
        const rtpParameters = (this.rtpParameters !== null ? this.rtpParameters.pack(builder) : 0);
        const rtpMapping = (this.rtpMapping !== null ? this.rtpMapping.pack(builder) : 0);
        ProduceRequest.startProduceRequest(builder);
        ProduceRequest.addProducerId(builder, producerId);
        ProduceRequest.addKind(builder, this.kind);
        ProduceRequest.addRtpParameters(builder, rtpParameters);
        ProduceRequest.addRtpMapping(builder, rtpMapping);
        ProduceRequest.addKeyFrameRequestDelay(builder, this.keyFrameRequestDelay);
        ProduceRequest.addPaused(builder, this.paused);
        return ProduceRequest.endProduceRequest(builder);
    }
}
exports.ProduceRequestT = ProduceRequestT;
